/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.demo.data.creator.internal;

import com.liferay.comment.demo.data.creator.CommentDemoDataCreator;
import com.liferay.comment.demo.data.creator.MultipleCommentDemoDataCreator;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MultipleCommentDemoDataCreator.class})
public class MultipleCommentDemoDataCreatorImpl
implements MultipleCommentDemoDataCreator {
    private static final int _COMMENT_ID = 0;
    private static final int _MAX_COMMENTS = 100;
    private static final int _MAX_LEVEL = 3;
    private static final int _MAX_REPLIES = 10;
    private static final int _MAX_USERS = 100;
    private static final List<String> _excludedUsers = Arrays.asList("test@liferay.com", "default@liferay.com");
    @Reference
    private CommentDemoDataCreator _commentDemoDataCreator;
    @Reference
    private UserLocalService _userLocalService;

    public void create(ClassedModel classedModel) throws PortalException {
        List users = this._userLocalService.getUsers(0, Math.min(this._userLocalService.getUsersCount(), 100));
        Stream<Object> usersStream = users.stream();
        usersStream = usersStream.filter(this::_isRegularUser);
        Stream<Long> userIdsStream = usersStream.map(UserModel::getUserId);
        List<Long> userIds = userIdsStream.collect(Collectors.toList());
        this._addComments(userIds, classedModel, 0L, RandomUtil.nextInt((int)100), 1);
    }

    public void delete() throws PortalException {
        this._commentDemoDataCreator.delete();
    }

    private int _addComments(List<Long> userIds, ClassedModel classedModel, long commentId, int maxComments, int level) throws PortalException {
        int commentsCount = 0;
        int maxReplies = RandomUtil.nextInt((int)(10 / level));
        int repliesCount = 0;
        while (commentsCount < maxComments && repliesCount < maxReplies) {
            Comment comment = null;
            long userId = this._getRandomElement(userIds);
            if (commentId == 0L) {
                comment = this._commentDemoDataCreator.create(userId, classedModel);
            } else {
                comment = this._commentDemoDataCreator.create(userId, commentId);
                ++repliesCount;
            }
            ++commentsCount;
            if (level >= 3) continue;
            commentsCount += this._addComments(userIds, classedModel, comment.getCommentId(), maxComments - commentsCount, level + 1);
        }
        return commentsCount;
    }

    private <T> T _getRandomElement(List<T> list) {
        return list.get(RandomUtil.nextInt((int)list.size()));
    }

    private boolean _isRegularUser(User user) {
        return !_excludedUsers.contains(user.getEmailAddress());
    }
}

