/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.upgrade;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.petra.function.UnsafeBiFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.sql.Connection;

public class UpgradeDiscussionSubscriptionClassName
extends UpgradeProcess {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final DeletionMode _deletionMode;
    private final String _oldSubscriptionClassName;
    private final SubscriptionLocalService _subscriptionLocalService;
    private final UnsafeBiFunction<String, Connection, Boolean, Exception> _unsafeBiFunction;

    public UpgradeDiscussionSubscriptionClassName(AssetEntryLocalService assetEntryLocalService, ClassNameLocalService classNameLocalService, SubscriptionLocalService subscriptionLocalService, String oldSubscriptionClassName, DeletionMode deletionMode) {
        this(assetEntryLocalService, classNameLocalService, subscriptionLocalService, oldSubscriptionClassName, deletionMode, null);
    }

    public UpgradeDiscussionSubscriptionClassName(AssetEntryLocalService assetEntryLocalService, ClassNameLocalService classNameLocalService, SubscriptionLocalService subscriptionLocalService, String oldSubscriptionClassName, UnsafeBiFunction<String, Connection, Boolean, Exception> unsafeBiFunction) {
        this(assetEntryLocalService, classNameLocalService, subscriptionLocalService, oldSubscriptionClassName, null, unsafeBiFunction);
    }

    @Deprecated
    public UpgradeDiscussionSubscriptionClassName(SubscriptionLocalService subscriptionLocalService, String oldSubscriptionClassName, DeletionMode deletionMode) {
        this(AssetEntryLocalServiceUtil.getService(), ClassNameLocalServiceUtil.getService(), subscriptionLocalService, oldSubscriptionClassName, deletionMode);
    }

    protected void doUpgrade() throws Exception {
        if (this._unsafeBiFunction != null) {
            this._unsafeBiFunction.apply((Object)this._oldSubscriptionClassName, (Object)this.connection);
        } else if (this._deletionMode == DeletionMode.ADD_NEW) {
            this._addSubscriptions();
        } else if (this._deletionMode == DeletionMode.DELETE_OLD) {
            this._deleteSubscriptions();
        } else {
            this._updateSubscriptions();
        }
    }

    private UpgradeDiscussionSubscriptionClassName(AssetEntryLocalService assetEntryLocalService, ClassNameLocalService classNameLocalService, SubscriptionLocalService subscriptionLocalService, String oldSubscriptionClassName, DeletionMode deletionMode, UnsafeBiFunction<String, Connection, Boolean, Exception> unsafeBiFunction) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._classNameLocalService = classNameLocalService;
        this._subscriptionLocalService = subscriptionLocalService;
        this._oldSubscriptionClassName = oldSubscriptionClassName;
        this._deletionMode = deletionMode;
        this._unsafeBiFunction = unsafeBiFunction;
    }

    private void _addSubscriptions() throws Exception {
        String newSubscriptionClassName = MBDiscussion.class.getName() + "_" + this._oldSubscriptionClassName;
        ActionableDynamicQuery actionableDynamicQuery = this._subscriptionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)this._classNameLocalService.getClassNameId(this._oldSubscriptionClassName))));
        actionableDynamicQuery.setPerformActionMethod(subscription -> this._subscriptionLocalService.addSubscription(subscription.getUserId(), subscription.getGroupId(), newSubscriptionClassName, subscription.getClassPK()));
        actionableDynamicQuery.performActions();
    }

    private void _deleteSubscriptions() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._subscriptionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)this._classNameLocalService.getClassNameId(this._oldSubscriptionClassName))));
        actionableDynamicQuery.setPerformActionMethod(subscription -> this._subscriptionLocalService.deleteSubscription(subscription.getSubscriptionId()));
        actionableDynamicQuery.performActions();
    }

    private void _updateSubscriptions() throws Exception {
        String newSubscriptionClassName = MBDiscussion.class.getName() + "_" + this._oldSubscriptionClassName;
        ActionableDynamicQuery actionableDynamicQuery = this._subscriptionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)this._classNameLocalService.getClassNameId(this._oldSubscriptionClassName))));
        actionableDynamicQuery.setPerformActionMethod(subscription -> {
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(newSubscriptionClassName, subscription.getClassPK());
            if (assetEntry == null) {
                this._assetEntryLocalService.updateEntry(subscription.getUserId(), subscription.getGroupId(), subscription.getCreateDate(), subscription.getModifiedDate(), newSubscriptionClassName, subscription.getClassPK(), null, 0L, null, null, true, false, null, null, null, null, null, String.valueOf(subscription.getGroupId()), null, null, null, null, 0, 0, null);
            }
        });
        actionableDynamicQuery.performActions();
        this.runSQL(StringBundler.concat((Object[])new Object[]{"update Subscription set classNameId = ", ClassNameLocalServiceUtil.getClassNameId((String)newSubscriptionClassName), " where classNameId = ", ClassNameLocalServiceUtil.getClassNameId((String)this._oldSubscriptionClassName)}));
    }

    public static enum DeletionMode {
        ADD_NEW,
        DELETE_OLD,
        UPDATE;

    }
}

