/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.internal.upgrade.v1_1_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.stream.Stream;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CaptchaConfigurationPreferencesUpgradeProcess
extends UpgradeProcess {
    private final ConfigurationAdmin _configurationAdmin;

    public CaptchaConfigurationPreferencesUpgradeProcess(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    protected void doUpgrade() throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration("com.liferay.captcha.configuration.CaptchaConfiguration", "?");
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return;
        }
        String[] simpleCaptchaGimpyRenderers = GetterUtil.getStringValues(properties.get("simpleCaptchaGimpyRenderers"));
        if (simpleCaptchaGimpyRenderers.length == 0) {
            return;
        }
        String[] upgradedSimpleCaptchaGimpyRenderers = this._replaceArrayValue(simpleCaptchaGimpyRenderers, "nl.captcha.gimpy.BlockGimpyRenderer", "com.liferay.captcha.simplecaptcha.gimpy.BlockGimpyRenderer");
        upgradedSimpleCaptchaGimpyRenderers = this._replaceArrayValue(upgradedSimpleCaptchaGimpyRenderers, "nl.captcha.gimpy.DropShadowGimpyRenderer", "com.liferay.captcha.simplecaptcha.gimpy.DropShadowGimpyRenderer");
        upgradedSimpleCaptchaGimpyRenderers = this._replaceArrayValue(upgradedSimpleCaptchaGimpyRenderers, "nl.captcha.gimpy.RippleGimpyRenderer", "com.liferay.captcha.simplecaptcha.gimpy.RippleGimpyRenderer");
        properties.put("simpleCaptchaGimpyRenderers", upgradedSimpleCaptchaGimpyRenderers);
        configuration.update(properties);
    }

    private String[] _replaceArrayValue(String[] array, String target, String replacement) {
        Stream<String> stream = Arrays.stream(array);
        return (String[])stream.map(s -> target.equals(s.trim()) ? replacement : s).toArray(String[]::new);
    }
}

