/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.internal.configuration.persistence.listener;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.recaptcha.ReCaptchaImpl;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"model.class.name=com.liferay.captcha.configuration.CaptchaConfiguration"}, service={ConfigurationModelListener.class})
public class CaptchaConfigurationModelListener
implements ConfigurationModelListener {
    private ResourceBundle _resourceBundle;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        try {
            String captchaEngine = (String)properties.get("captchaEngine");
            if (Validator.isNotNull((String)captchaEngine) && captchaEngine.equals(ReCaptchaImpl.class.getName())) {
                this._validateReCaptchaKeys(properties);
            }
        }
        catch (CaptchaConfigurationException captchaConfigurationException) {
            throw new ConfigurationModelListenerException(captchaConfigurationException.getMessage(), CaptchaConfiguration.class, CaptchaConfigurationModelListener.class, properties);
        }
    }

    private ResourceBundle _getResourceBundle() {
        if (this._resourceBundle == null) {
            Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
            return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        }
        return this._resourceBundle;
    }

    private void _validateReCaptchaKeys(Dictionary<String, Object> properties) throws CaptchaConfigurationException {
        String reCaptchaPublicKey = (String)properties.get("reCaptchaPublicKey");
        if (Validator.isNull((String)reCaptchaPublicKey)) {
            throw new CaptchaConfigurationException(ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)"the-recaptcha-public-key-is-not-valid"));
        }
        String reCaptchaPrivateKey = (String)properties.get("reCaptchaPrivateKey");
        if (Validator.isNull((String)reCaptchaPrivateKey)) {
            throw new CaptchaConfigurationException(ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)"the-recaptcha-private-key-is-not-valid"));
        }
    }
}

