/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.recaptcha;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaConfigurationException;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.captcha.configuration.CaptchaConfiguration"}, immediate=true, property={"captcha.engine.impl=com.liferay.captcha.recaptcha.ReCaptchaImpl"}, service={Captcha.class})
public class ReCaptchaImpl
extends SimpleCaptchaImpl {
    private static final String _TAGLIB_PATH = "/captcha/recaptcha.jsp";
    private static final Log _log = LogFactoryUtil.getLog(ReCaptchaImpl.class);
    private volatile CaptchaConfiguration _captchaConfiguration;

    @Override
    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    @Override
    public void serveImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._captchaConfiguration = (CaptchaConfiguration)ConfigurableUtil.createConfigurable(CaptchaConfiguration.class, properties);
        this.setCaptchaConfiguration(this._captchaConfiguration);
    }

    @Override
    protected boolean validateChallenge(HttpServletRequest httpServletRequest) throws CaptchaException {
        String reCaptchaResponse = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"g-recaptcha-response");
        while (Validator.isBlank((String)reCaptchaResponse) && httpServletRequest instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)httpServletRequest;
            httpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
            reCaptchaResponse = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"g-recaptcha-response");
        }
        if (Validator.isBlank((String)reCaptchaResponse)) {
            _log.error((Object)("CAPTCHA text is null. User " + httpServletRequest.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaException();
        }
        Http.Options options = new Http.Options();
        options.setLocation(this._captchaConfiguration.reCaptchaVerifyURL());
        try {
            options.addPart("secret", this._captchaConfiguration.reCaptchaPrivateKey());
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
        }
        options.addPart("remoteip", httpServletRequest.getRemoteAddr());
        options.addPart("response", reCaptchaResponse);
        options.setPost(true);
        String content = null;
        try {
            content = HttpUtil.URLtoString((Http.Options)options);
        }
        catch (IOException ioException) {
            _log.error((Object)ioException, (Throwable)ioException);
            throw new CaptchaConfigurationException();
        }
        if (content == null) {
            _log.error((Object)"reCAPTCHA did not return a result");
            throw new CaptchaConfigurationException();
        }
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)content);
            String success = jsonObject.getString("success");
            if (StringUtil.equalsIgnoreCase((String)success, (String)"true")) {
                return true;
            }
            JSONArray jsonArray = jsonObject.getJSONArray("error-codes");
            if (jsonArray == null || jsonArray.length() == 0) {
                _log.error((Object)"reCAPTCHA encountered an error");
                throw new CaptchaConfigurationException();
            }
            StringBundler sb = new StringBundler(jsonArray.length() * 2 - 1);
            for (int i = 0; i < jsonArray.length(); ++i) {
                sb.append(jsonArray.getString(i));
                if (i >= jsonArray.length() - 1) continue;
                sb.append(", ");
            }
            _log.error((Object)("reCAPTCHA encountered an error: " + sb.toString()));
            throw new CaptchaConfigurationException();
        }
        catch (JSONException jsonException) {
            _log.error((Object)("reCAPTCHA did not return a valid result: " + content), (Throwable)jsonException);
            throw new CaptchaConfigurationException();
        }
    }

    @Override
    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        return this.validateChallenge(PortalUtil.getHttpServletRequest((PortletRequest)portletRequest));
    }
}

