/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.simplecaptcha;

import com.liferay.captcha.configuration.CaptchaConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.captcha.CaptchaTextException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.servlet.CaptchaServletUtil;
import nl.captcha.text.producer.TextProducer;
import nl.captcha.text.renderer.WordRenderer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.captcha.configuration.CaptchaConfiguration"}, immediate=true, property={"captcha.engine.impl=com.liferay.captcha.simplecaptcha.SimpleCaptchaImpl"}, service={com.liferay.portal.kernel.captcha.Captcha.class})
public class SimpleCaptchaImpl
implements com.liferay.portal.kernel.captcha.Captcha {
    private static final String _TAGLIB_PATH = "/captcha/simplecaptcha.jsp";
    private static final Log _log = LogFactoryUtil.getLog(SimpleCaptchaImpl.class);
    private BackgroundProducer[] _backgroundProducers;
    private volatile CaptchaConfiguration _captchaConfiguration;
    private GimpyRenderer[] _gimpyRenderers;
    private final Map<String, Object> _instances = new ConcurrentHashMap<String, Object>();
    private NoiseProducer[] _noiseProducers;
    private TextProducer[] _textProducers;
    private WordRenderer[] _wordRenderers;

    public void check(HttpServletRequest request) throws CaptchaException {
        if (!this.isEnabled(request)) {
            return;
        }
        if (!this.validateChallenge(request)) {
            throw new CaptchaTextException();
        }
        this.incrementCounter(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"CAPTCHA text is valid");
        }
    }

    public void check(PortletRequest portletRequest) throws CaptchaException {
        if (!this.isEnabled(portletRequest)) {
            return;
        }
        if (!this.validateChallenge(portletRequest)) {
            throw new CaptchaTextException();
        }
        this.incrementCounter(portletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"CAPTCHA text is valid");
        }
    }

    public String getTaglibPath() {
        return _TAGLIB_PATH;
    }

    public boolean isEnabled(HttpServletRequest request) {
        if (this.isExceededMaxChallenges(request)) {
            return false;
        }
        return this._captchaConfiguration.maxChallenges() >= 0;
    }

    public boolean isEnabled(PortletRequest portletRequest) {
        if (this.isExceededMaxChallenges(portletRequest)) {
            return false;
        }
        return this._captchaConfiguration.maxChallenges() >= 0;
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        session.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        response.setContentType("image/png");
        CaptchaServletUtil.writeImage((OutputStream)response.getOutputStream(), simpleCaptcha.getImage());
    }

    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        PortletSession portletSession = resourceRequest.getPortletSession();
        Captcha simpleCaptcha = this.getSimpleCaptcha();
        portletSession.setAttribute("CAPTCHA_TEXT", (Object)simpleCaptcha.getAnswer());
        resourceResponse.setContentType("image/png");
        CaptchaServletUtil.writeImage(resourceResponse.getPortletOutputStream(), simpleCaptcha.getImage());
    }

    protected void activate() {
        this.initBackgroundProducers();
        this.initGimpyRenderers();
        this.initNoiseProducers();
        this.initTextProducers();
        this.initWordRenderers();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._captchaConfiguration = (CaptchaConfiguration)ConfigurableUtil.createConfigurable(CaptchaConfiguration.class, properties);
        this.activate();
    }

    protected BackgroundProducer getBackgroundProducer() {
        if (this._backgroundProducers.length == 1) {
            return this._backgroundProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._backgroundProducers.length);
        return this._backgroundProducers[pos];
    }

    protected GimpyRenderer getGimpyRenderer() {
        if (this._gimpyRenderers.length == 1) {
            return this._gimpyRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._gimpyRenderers.length);
        return this._gimpyRenderers[pos];
    }

    protected int getHeight() {
        return this._captchaConfiguration.simpleCaptchaHeight();
    }

    protected NoiseProducer getNoiseProducer() {
        if (this._noiseProducers.length == 1) {
            return this._noiseProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._noiseProducers.length);
        return this._noiseProducers[pos];
    }

    protected Captcha getSimpleCaptcha() {
        Captcha.Builder captchaBuilder = new Captcha.Builder(this.getWidth(), this.getHeight());
        captchaBuilder.addText(this.getTextProducer(), this.getWordRenderer());
        captchaBuilder.addBackground(this.getBackgroundProducer());
        captchaBuilder.gimp(this.getGimpyRenderer());
        captchaBuilder.addNoise(this.getNoiseProducer());
        captchaBuilder.addBorder();
        return captchaBuilder.build();
    }

    protected TextProducer getTextProducer() {
        if (this._textProducers.length == 1) {
            return this._textProducers[0];
        }
        int pos = RandomUtil.nextInt((int)this._textProducers.length);
        return this._textProducers[pos];
    }

    protected int getWidth() {
        return this._captchaConfiguration.simpleCaptchaWidth();
    }

    protected WordRenderer getWordRenderer() {
        if (this._wordRenderers.length == 1) {
            return this._wordRenderers[0];
        }
        int pos = RandomUtil.nextInt((int)this._wordRenderers.length);
        return this._wordRenderers[pos];
    }

    protected void incrementCounter(HttpServletRequest request) {
        if (this._captchaConfiguration.maxChallenges() > 0 && Validator.isNotNull((String)request.getRemoteUser())) {
            HttpSession session = request.getSession();
            Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
            session.setAttribute("CAPTCHA_COUNT", (Object)this.incrementCounter(count));
        }
    }

    protected Integer incrementCounter(Integer count) {
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        return count;
    }

    protected void incrementCounter(PortletRequest portletRequest) {
        if (this._captchaConfiguration.maxChallenges() > 0 && Validator.isNotNull((String)portletRequest.getRemoteUser())) {
            PortletSession portletSession = portletRequest.getPortletSession();
            Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
            portletSession.setAttribute("CAPTCHA_COUNT", (Object)this.incrementCounter(count));
        }
    }

    protected void initBackgroundProducers() {
        String[] backgroundProducerClassNames = this._captchaConfiguration.simpleCaptchaBackgroundProducers();
        this._backgroundProducers = new BackgroundProducer[backgroundProducerClassNames.length];
        for (int i = 0; i < backgroundProducerClassNames.length; ++i) {
            String backgroundProducerClassName = backgroundProducerClassNames[i];
            this._backgroundProducers[i] = (BackgroundProducer)this._getInstance(backgroundProducerClassName);
        }
    }

    protected void initGimpyRenderers() {
        String[] gimpyRendererClassNames = this._captchaConfiguration.simpleCaptchaGimpyRenderers();
        this._gimpyRenderers = new GimpyRenderer[gimpyRendererClassNames.length];
        for (int i = 0; i < gimpyRendererClassNames.length; ++i) {
            String gimpyRendererClassName = gimpyRendererClassNames[i];
            this._gimpyRenderers[i] = (GimpyRenderer)this._getInstance(gimpyRendererClassName);
        }
    }

    protected void initNoiseProducers() {
        String[] noiseProducerClassNames = this._captchaConfiguration.simpleCaptchaNoiseProducers();
        this._noiseProducers = new NoiseProducer[noiseProducerClassNames.length];
        for (int i = 0; i < noiseProducerClassNames.length; ++i) {
            String noiseProducerClassName = noiseProducerClassNames[i];
            this._noiseProducers[i] = (NoiseProducer)this._getInstance(noiseProducerClassName);
        }
    }

    protected void initTextProducers() {
        String[] textProducerClassNames = this._captchaConfiguration.simpleCaptchaTextProducers();
        this._textProducers = new TextProducer[textProducerClassNames.length];
        for (int i = 0; i < textProducerClassNames.length; ++i) {
            String textProducerClassName = textProducerClassNames[i];
            this._textProducers[i] = (TextProducer)this._getInstance(textProducerClassName);
        }
    }

    protected void initWordRenderers() {
        String[] wordRendererClassNames = this._captchaConfiguration.simpleCaptchaWordRenderers();
        this._wordRenderers = new WordRenderer[wordRendererClassNames.length];
        for (int i = 0; i < wordRendererClassNames.length; ++i) {
            String wordRendererClassName = wordRendererClassNames[i];
            this._wordRenderers[i] = (WordRenderer)this._getInstance(wordRendererClassName);
        }
    }

    protected boolean isExceededMaxChallenges(HttpServletRequest request) {
        if (this._captchaConfiguration.maxChallenges() > 0) {
            HttpSession session = request.getSession();
            Integer count = (Integer)session.getAttribute("CAPTCHA_COUNT");
            return this.isExceededMaxChallenges(count);
        }
        return false;
    }

    protected boolean isExceededMaxChallenges(Integer count) {
        return count != null && count >= this._captchaConfiguration.maxChallenges();
    }

    protected boolean isExceededMaxChallenges(PortletRequest portletRequest) {
        if (this._captchaConfiguration.maxChallenges() > 0) {
            PortletSession portletSession = portletRequest.getPortletSession();
            Integer count = (Integer)portletSession.getAttribute("CAPTCHA_COUNT");
            return this.isExceededMaxChallenges(count);
        }
        return false;
    }

    protected void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this._captchaConfiguration = captchaConfiguration;
    }

    protected boolean validateChallenge(HttpServletRequest request) throws CaptchaException {
        HttpSession session = request.getSession();
        String captchaText = (String)session.getAttribute("CAPTCHA_TEXT");
        if (request instanceof UploadPortletRequest) {
            UploadPortletRequest uploadPortletRequest = (UploadPortletRequest)request;
            PortletRequest portletRequest = uploadPortletRequest.getPortletRequest();
            PortletSession portletSession = portletRequest.getPortletSession();
            captchaText = (String)portletSession.getAttribute("CAPTCHA_TEXT");
        }
        if (captchaText == null) {
            _log.error((Object)("CAPTCHA text is null. User " + request.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        boolean valid = captchaText.equals(ParamUtil.getString((HttpServletRequest)request, (String)"captchaText"));
        if (valid) {
            if (request instanceof UploadPortletRequest) {
                UploadPortletRequest uploadPortletRequest = (UploadPortletRequest)request;
                PortletRequest portletRequest = uploadPortletRequest.getPortletRequest();
                PortletSession portletSession = portletRequest.getPortletSession();
                portletSession.removeAttribute("CAPTCHA_TEXT");
            } else {
                session.removeAttribute("CAPTCHA_TEXT");
            }
        }
        return valid;
    }

    protected boolean validateChallenge(PortletRequest portletRequest) throws CaptchaException {
        PortletSession portletSession = portletRequest.getPortletSession();
        String captchaText = (String)portletSession.getAttribute("CAPTCHA_TEXT");
        if (captchaText == null) {
            _log.error((Object)("CAPTCHA text is null. User " + portletRequest.getRemoteUser() + " may be trying to circumvent the CAPTCHA."));
            throw new CaptchaTextException();
        }
        boolean valid = captchaText.equals(ParamUtil.getString((PortletRequest)portletRequest, (String)"captchaText"));
        if (valid) {
            portletSession.removeAttribute("CAPTCHA_TEXT");
        }
        return valid;
    }

    private Object _getInstance(String className) {
        Object instance = this._instances.get(className = className.trim());
        if (instance != null) {
            return instance;
        }
        try {
            Class<?> clazz = this._loadClass(className);
            instance = clazz.newInstance();
            this._instances.put(className, instance);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to load " + className), (Throwable)e);
        }
        return instance;
    }

    private Class<?> _loadClass(String className) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.loadClass(className);
    }
}

