/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.captcha.util;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(immediate=true, service={CaptchaUtil.class})
public class CaptchaUtil {
    private static final String _CAPTCHA_ENGINE_IMPL = PropsUtil.get((String)"captcha.engine.impl");
    private static ServiceTrackerMap<String, Captcha> _serviceTrackerMap;

    public static void check(HttpServletRequest request) throws CaptchaException {
        CaptchaUtil.getCaptcha().check(request);
    }

    public static void check(PortletRequest portletRequest) throws CaptchaException {
        CaptchaUtil.getCaptcha().check(portletRequest);
    }

    public static Captcha getCaptcha() {
        String captchaClassName = PrefsPropsUtil.getString((String)"captcha.engine.impl", (String)_CAPTCHA_ENGINE_IMPL);
        return (Captcha)_serviceTrackerMap.getService((Object)captchaClassName);
    }

    public static String getTaglibPath() {
        return CaptchaUtil.getCaptcha().getTaglibPath();
    }

    public static boolean isEnabled(HttpServletRequest request) {
        return CaptchaUtil.getCaptcha().isEnabled(request);
    }

    public static boolean isEnabled(PortletRequest portletRequest) {
        return CaptchaUtil.getCaptcha().isEnabled(portletRequest);
    }

    public static void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CaptchaUtil.getCaptcha().serveImage(request, response);
    }

    public static void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        CaptchaUtil.getCaptcha().serveImage(resourceRequest, resourceResponse);
    }

    public static void setCaptcha(Captcha captcha) throws Exception {
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences();
        Class<?> clazz = captcha.getClass();
        portletPreferences.setValue("captcha.engine.impl", clazz.getName());
        portletPreferences.store();
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        _serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Captcha.class, (String)"captcha.engine.impl");
    }

    @Deactivate
    protected void deactivate() {
        _serviceTrackerMap.close();
        _serviceTrackerMap = null;
    }
}

