/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.calendar.service;

import aQute.bnd.annotation.ProviderType;

import com.liferay.calendar.model.CalendarBooking;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.service.BaseService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;

import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Provides the remote service interface for CalendarBooking. Methods of this
 * service are expected to have security checks based on the propagated JAAS
 * credentials because this service can be accessed remotely.
 *
 * @author Eduardo Lundgren
 * @see CalendarBookingServiceUtil
 * @see com.liferay.calendar.service.base.CalendarBookingServiceBaseImpl
 * @see com.liferay.calendar.service.impl.CalendarBookingServiceImpl
 * @generated
 */
@AccessControlled
@JSONWebService
@OSGiBeanProperties(property =  {
	"json.web.service.context.name=calendar", "json.web.service.context.path=CalendarBooking"}, service = CalendarBookingService.class)
@ProviderType
@Transactional(isolation = Isolation.PORTAL, rollbackFor =  {
	PortalException.class, SystemException.class})
public interface CalendarBookingService extends BaseService {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. Always use {@link CalendarBookingServiceUtil} to access the calendar booking remote service. Add custom service methods to {@link com.liferay.calendar.service.impl.CalendarBookingServiceImpl} and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public CalendarBooking addCalendarBooking(long calendarId,
		long[] childCalendarIds, long parentCalendarBookingId,
		long recurringCalendarBookingId, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, int startTimeYear,
		int startTimeMonth, int startTimeDay, int startTimeHour,
		int startTimeMinute, int endTimeYear, int endTimeMonth, int endTimeDay,
		int endTimeHour, int endTimeMinute, String timeZoneId, boolean allDay,
		String recurrence, long firstReminder, String firstReminderType,
		long secondReminder, String secondReminderType,
		ServiceContext serviceContext) throws PortalException;

	public CalendarBooking addCalendarBooking(long calendarId,
		long[] childCalendarIds, long parentCalendarBookingId,
		long recurringCalendarBookingId, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long startTime,
		long endTime, boolean allDay, String recurrence, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	/**
	* @deprecated As of Judson (7.1.x), replaced by {@link
	#addCalendarBooking(long, long[], long, long, Map, Map,
	String, long, long, boolean, String, long, String, long,
	String, ServiceContext)}
	*/
	@Deprecated
	public CalendarBooking addCalendarBooking(long calendarId,
		long[] childCalendarIds, long parentCalendarBookingId,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, int startTimeYear, int startTimeMonth,
		int startTimeDay, int startTimeHour, int startTimeMinute,
		int endTimeYear, int endTimeMonth, int endTimeDay, int endTimeHour,
		int endTimeMinute, String timeZoneId, boolean allDay,
		String recurrence, long firstReminder, String firstReminderType,
		long secondReminder, String secondReminderType,
		ServiceContext serviceContext) throws PortalException;

	/**
	* @deprecated As of Judson (7.1.x)
	*/
	@Deprecated
	public CalendarBooking addCalendarBooking(long calendarId,
		long[] childCalendarIds, long parentCalendarBookingId,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, long startTime, long endTime, boolean allDay,
		String recurrence, long firstReminder, String firstReminderType,
		long secondReminder, String secondReminderType,
		ServiceContext serviceContext) throws PortalException;

	public CalendarBooking deleteCalendarBooking(long calendarBookingId)
		throws PortalException;

	public void deleteCalendarBookingInstance(long calendarBookingId,
		int instanceIndex, boolean allFollowing) throws PortalException;

	public void deleteCalendarBookingInstance(long calendarBookingId,
		int instanceIndex, boolean allFollowing,
		boolean deleteRecurringCalendarBookings) throws PortalException;

	public void deleteCalendarBookingInstance(long calendarBookingId,
		long startTime, boolean allFollowing) throws PortalException;

	public String exportCalendarBooking(long calendarBookingId, String type)
		throws Exception;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking fetchCalendarBooking(long calendarBookingId)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking getCalendarBooking(long calendarBookingId)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking getCalendarBooking(long calendarId,
		long parentCalendarBookingId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking getCalendarBookingInstance(long calendarBookingId,
		int instanceIndex) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getCalendarBookings(long calendarId,
		int[] statuses) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getCalendarBookings(long calendarId,
		long startTime, long endTime) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getCalendarBookings(long calendarId,
		long startTime, long endTime, int max) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public String getCalendarBookingsRSS(long calendarId, long startTime,
		long endTime, int max, String type, double version,
		String displayStyle, ThemeDisplay themeDisplay)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getChildCalendarBookings(
		long parentCalendarBookingId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getChildCalendarBookings(
		long parentCalendarBookingId, boolean includeStagingCalendarBookings)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> getChildCalendarBookings(
		long parentCalendarBookingId, int status) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking getLastInstanceCalendarBooking(
		long calendarBookingId) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public CalendarBooking getNewStartTimeAndDurationCalendarBooking(
		long calendarBookingId, long offset, long duration)
		throws PortalException;

	/**
	* Returns the OSGi service identifier.
	*
	* @return the OSGi service identifier
	*/
	public String getOSGiServiceIdentifier();

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean hasChildCalendarBookings(long parentCalendarBookingId);

	public CalendarBooking invokeTransition(long calendarBookingId,
		int instanceIndex, int status, boolean updateInstance,
		boolean allFollowing, ServiceContext serviceContext)
		throws PortalException;

	/**
	* @deprecated As of Judson (7.1.x), replaced by {@link
	#invokeTransition(long, int, long, boolean, boolean,
	ServiceContext)}
	*/
	@Deprecated
	public void invokeTransition(long calendarBookingId, int status,
		ServiceContext serviceContext) throws PortalException;

	public CalendarBooking invokeTransition(long calendarBookingId,
		long startTime, int status, boolean updateInstance,
		boolean allFollowing, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking moveCalendarBookingToTrash(long calendarBookingId)
		throws PortalException;

	public CalendarBooking restoreCalendarBookingFromTrash(
		long calendarBookingId) throws PortalException;

	@AccessControlled(guestAccessEnabled = true)
	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> search(long companyId, long[] groupIds,
		long[] calendarIds, long[] calendarResourceIds,
		long parentCalendarBookingId, String keywords, long startTime,
		long endTime, boolean recurring, int[] statuses, int start, int end,
		OrderByComparator<CalendarBooking> orderByComparator)
		throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<CalendarBooking> search(long companyId, long[] groupIds,
		long[] calendarIds, long[] calendarResourceIds,
		long parentCalendarBookingId, String title, String description,
		String location, long startTime, long endTime, boolean recurring,
		int[] statuses, boolean andOperator, int start, int end,
		OrderByComparator<CalendarBooking> orderByComparator)
		throws PortalException;

	@AccessControlled(guestAccessEnabled = true)
	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds, long[] calendarIds,
		long[] calendarResourceIds, long parentCalendarBookingId,
		String keywords, long startTime, long endTime, boolean recurring,
		int[] statuses) throws PortalException;

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public int searchCount(long companyId, long[] groupIds, long[] calendarIds,
		long[] calendarResourceIds, long parentCalendarBookingId, String title,
		String description, String location, long startTime, long endTime,
		boolean recurring, int[] statuses, boolean andOperator)
		throws PortalException;

	public CalendarBooking updateCalendarBooking(long calendarBookingId,
		long calendarId, long[] childCalendarIds, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long startTime,
		long endTime, boolean allDay, String recurrence, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateCalendarBooking(long calendarBookingId,
		long calendarId, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long startTime,
		long endTime, boolean allDay, String recurrence, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateCalendarBookingInstance(
		long calendarBookingId, int instanceIndex, long calendarId,
		long[] childCalendarIds, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long startTime,
		long endTime, boolean allDay, boolean allFollowing, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateCalendarBookingInstance(
		long calendarBookingId, int instanceIndex, long calendarId,
		long[] childCalendarIds, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long startTime,
		long endTime, boolean allDay, String recurrence, boolean allFollowing,
		long firstReminder, String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateCalendarBookingInstance(
		long calendarBookingId, int instanceIndex, long calendarId,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, int startTimeYear, int startTimeMonth,
		int startTimeDay, int startTimeHour, int startTimeMinute,
		int endTimeYear, int endTimeMonth, int endTimeDay, int endTimeHour,
		int endTimeMinute, String timeZoneId, boolean allDay,
		String recurrence, boolean allFollowing, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateCalendarBookingInstance(
		long calendarBookingId, int instanceIndex, long calendarId,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, long startTime, long endTime, boolean allDay,
		String recurrence, boolean allFollowing, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public void updateLastInstanceCalendarBookingRecurrence(
		long calendarBookingId, String recurrence) throws PortalException;

	public CalendarBooking updateOffsetAndDuration(long calendarBookingId,
		long calendarId, long[] childCalendarIds, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long offset,
		long duration, boolean allDay, String recurrence, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateOffsetAndDuration(long calendarBookingId,
		long calendarId, Map<Locale, String> titleMap,
		Map<Locale, String> descriptionMap, String location, long offset,
		long duration, boolean allDay, String recurrence, long firstReminder,
		String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	public CalendarBooking updateRecurringCalendarBooking(
		long calendarBookingId, long calendarId, long[] childCalendarIds,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, long startTime, long endTime, boolean allDay,
		long firstReminder, String firstReminderType, long secondReminder,
		String secondReminderType, ServiceContext serviceContext)
		throws PortalException;

	/**
	* @deprecated As of Judson (7.1.x), replaced by {@link
	#updateRecurringCalendarBooking(long, long, long[], Map, Map,
	String, long, long, boolean, long, String, long, String,
	ServiceContext)
	*/
	@Deprecated
	public CalendarBooking updateRecurringCalendarBooking(
		long calendarBookingId, long calendarId, long[] childCalendarIds,
		Map<Locale, String> titleMap, Map<Locale, String> descriptionMap,
		String location, long startTime, long endTime, boolean allDay,
		String recurrence, long firstReminder, String firstReminderType,
		long secondReminder, String secondReminderType,
		ServiceContext serviceContext) throws PortalException;
}