/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.trash;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.bookmarks.web.internal.asset.BookmarksFolderAssetRenderer;
import com.liferay.bookmarks.web.internal.trash.BookmarksBaseTrashHandler;
import com.liferay.bookmarks.web.internal.util.BookmarksUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.trash.TrashHelper;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksFolder"}, service={TrashHandler.class})
public class BookmarksFolderTrashHandler
extends BookmarksBaseTrashHandler {
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    @Reference
    private TrashHelper _trashHelper;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._bookmarksFolderLocalService.deleteFolder(classPK, false);
    }

    public String getClassName() {
        return BookmarksFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, folder.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, folder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return BookmarksUtil.getAbsolutePath(portletRequest, folder.getParentFolderId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._bookmarksFolderLocalService.fetchBookmarksFolder(classPK);
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return new BookmarksFolderAssetRenderer(folder, this._trashHelper, this._bookmarksFolderModelResourcePermission);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionHelper.contains(this._bookmarksFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isRestorable(long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        if (folder.getParentFolderId() > 0L && this._bookmarksFolderLocalService.fetchBookmarksFolder(folder.getParentFolderId()) == null) {
            return false;
        }
        return !folder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._bookmarksFolderLocalService.moveFolder(classPK, containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException {
        this._bookmarksFolderLocalService.moveFolderFromTrash(userId, classPK, containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._bookmarksFolderLocalService.restoreFolderFromTrash(userId, classPK);
    }

    protected BookmarksFolder getBookmarksFolder(long classPK) throws PortalException {
        return this._bookmarksFolderLocalService.getFolder(classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return folder.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        BookmarksFolder folder = this.getBookmarksFolder(classPK);
        return this._bookmarksFolderModelResourcePermission.contains(permissionChecker, (ClassedModel)folder, actionId);
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderLocalService(BookmarksFolderLocalService bookmarksFolderLocalService) {
        this._bookmarksFolderLocalService = bookmarksFolderLocalService;
    }
}

