/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.trash;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalService;
import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.bookmarks.web.internal.trash.BookmarksBaseTrashHandler;
import com.liferay.bookmarks.web.internal.util.BookmarksUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.bookmarks.model.BookmarksEntry"}, service={TrashHandler.class})
public class BookmarksEntryTrashHandler
extends BookmarksBaseTrashHandler {
    private BookmarksEntryLocalService _bookmarksEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksEntry)")
    private ModelResourcePermission<BookmarksEntry> _bookmarksEntryModelResourcePermission;
    private BookmarksFolderLocalService _bookmarksFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;

    public void deleteTrashEntry(long classPK) throws PortalException {
        this._bookmarksEntryLocalService.deleteEntry(classPK);
    }

    public String getClassName() {
        return BookmarksEntry.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        long parentFolderId = entry.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        BookmarksEntry entry = (BookmarksEntry)trashedModel;
        return this.getContainerModel(entry.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        return BookmarksUtil.getControlPanelLink(portletRequest, entry.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        return BookmarksUtil.getAbsolutePath(portletRequest, entry.getFolderId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._bookmarksEntryLocalService.fetchBookmarksEntry(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionHelper.contains(this._bookmarksFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_ENTRY");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isRestorable(long classPK) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        if (entry.getFolderId() > 0L && this._bookmarksFolderLocalService.fetchBookmarksFolder(entry.getFolderId()) == null) {
            return false;
        }
        return !entry.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._bookmarksEntryLocalService.moveEntry(classPK, containerModelId);
    }

    public void moveTrashEntry(long userId, long classPK, long containerId, ServiceContext serviceContext) throws PortalException {
        this._bookmarksEntryLocalService.moveEntryFromTrash(userId, classPK, containerId);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        this._bookmarksEntryLocalService.restoreEntryFromTrash(userId, classPK);
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        return entry.getGroupId();
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        BookmarksEntry entry = this._bookmarksEntryLocalService.getEntry(classPK);
        return this._bookmarksEntryModelResourcePermission.contains(permissionChecker, (ClassedModel)entry, actionId);
    }

    @Reference(unbind="-")
    protected void setBookmarksEntryLocalService(BookmarksEntryLocalService bookmarksEntryLocalService) {
        this._bookmarksEntryLocalService = bookmarksEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderLocalService(BookmarksFolderLocalService bookmarksFolderLocalService) {
        this._bookmarksFolderLocalService = bookmarksFolderLocalService;
    }
}

