/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.util;

import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksEntryLocalServiceUtil;
import com.liferay.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.bookmarks.util.comparator.EntryCreateDateComparator;
import com.liferay.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.bookmarks.util.comparator.EntryPriorityComparator;
import com.liferay.bookmarks.util.comparator.EntryURLComparator;
import com.liferay.bookmarks.util.comparator.EntryVisitsComparator;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class BookmarksUtil {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksUtil.class);

    public static void addPortletBreadcrumbEntries(BookmarksEntry entry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        BookmarksFolder folder = entry.getFolder();
        if (folder.getFolderId() != 0L) {
            BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    public static void addPortletBreadcrumbEntries(BookmarksFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (mvcRenderCommandName.equals("/bookmarks/select_folder")) {
            portletURL.setParameter("mvcRenderCommandName", "/bookmarks/select_folder");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
        }
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        if (folder == null) {
            return;
        }
        if (!mvcRenderCommandName.equals("/bookmarks/select_folder")) {
            portletURL.setParameter("mvcRenderCommandName", "/bookmarks/view_folder");
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (BookmarksFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString());
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            BookmarksFolder unescapedFolder = folder.toUnescapedModel();
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString());
        }
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
        BookmarksUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$BOOKMARKS_ENTRY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-added-the-bookmark-entry"));
        definitionTerms.put("[$BOOKMARKS_ENTRY_STATUS_BY_USER_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-user-who-updated-the-bookmark-entry"));
        definitionTerms.put("[$BOOKMARKS_ENTRY_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-bookmark-entry-url"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static List<Object> getEntries(Hits hits) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Document document : hits.getDocs()) {
            String entryClassName = document.get("entryClassName");
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            try {
                BookmarksEntry obj = null;
                if (entryClassName.equals(BookmarksEntry.class.getName())) {
                    obj = BookmarksEntryLocalServiceUtil.getEntry((long)entryClassPK);
                } else if (entryClassName.equals(BookmarksFolder.class.getName())) {
                    obj = BookmarksFolderLocalServiceUtil.getFolder((long)entryClassPK);
                }
                entries.add(obj);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Bookmarks search index is stale and contains entry " + entryClassPK));
            }
        }
        return entries;
    }

    public static OrderByComparator<BookmarksEntry> getEntryOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        EntryCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new EntryCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new EntryModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("name")) {
            orderByComparator = new EntryNameComparator(orderByAsc);
        } else if (orderByCol.equals("priority")) {
            orderByComparator = new EntryPriorityComparator(orderByAsc);
        } else if (orderByCol.equals("url")) {
            orderByComparator = new EntryURLComparator(orderByAsc);
        } else if (orderByCol.equals("visits")) {
            orderByComparator = new EntryVisitsComparator(orderByAsc);
        }
        return orderByComparator;
    }
}

