/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.toolbar.contributor;

import com.liferay.bookmarks.configuration.BookmarksGroupServiceOverriddenConfiguration;
import com.liferay.bookmarks.exception.NoSuchFolderException;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderService;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.toolbar.contributor.BasePortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "mvc.render.command.name=-", "mvc.render.command.name=/bookmarks/view", "mvc.render.command.name=/bookmarks/view_folder"}, service={BookmarksPortletToolbarContributor.class, PortletToolbarContributor.class})
public class BookmarksPortletToolbarContributor
extends BasePortletToolbarContributor {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksPortletToolbarContributor.class);
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    private BookmarksFolderService _bookmarksFolderService;
    @Reference
    private Portal _portal;

    protected void addPortletTitleAddBookmarkMenuItem(List<MenuItem> menuItems, BookmarksFolder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) throws PortalException {
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_ENTRY")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"bookmark"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/bookmarks/edit_entry");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected void addPortletTitleAddFolderMenuItem(List<MenuItem> menuItems, BookmarksFolder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) throws PortalException {
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_FOLDER")) {
            return;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)(folder != null ? "subfolder" : "folder")));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/bookmarks/edit_folder");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("parentFolderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)urlMenuItem);
    }

    protected boolean containsPermission(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) {
        try {
            return ModelResourcePermissionHelper.contains(this._bookmarksFolderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)folderId, (String)actionId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    protected List<MenuItem> getPortletTitleMenuItems(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        BookmarksFolder folder = this._getFolder(themeDisplay, portletRequest);
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        try {
            this.addPortletTitleAddFolderMenuItem(menuItems, folder, themeDisplay, portletRequest);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to add folder menu item", (Throwable)pe);
        }
        try {
            this.addPortletTitleAddBookmarkMenuItem(menuItems, folder, themeDisplay, portletRequest);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to add bookmark menu item", (Throwable)pe);
        }
        return menuItems;
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderService(BookmarksFolderService bookmarksFolderService) {
        this._bookmarksFolderService = bookmarksFolderService;
    }

    private BookmarksFolder _getFolder(ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        BookmarksFolder folder = (BookmarksFolder)portletRequest.getAttribute("BOOKMARKS_FOLDER");
        if (folder != null) {
            return folder;
        }
        long rootFolderId = 0L;
        try {
            BookmarksGroupServiceOverriddenConfiguration bookmarksGroupServiceOverriddenConfiguration = (BookmarksGroupServiceOverriddenConfiguration)ConfigurationProviderUtil.getConfiguration(BookmarksGroupServiceOverriddenConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(themeDisplay.getScopeGroupId(), "com.liferay.bookmarks"));
            rootFolderId = bookmarksGroupServiceOverriddenConfiguration.rootFolderId();
        }
        catch (ConfigurationException ce) {
            _log.error((Object)("Unable to obtain bookmarks root folder ID for group " + themeDisplay.getScopeGroupId()), (Throwable)ce);
        }
        long folderId = BeanParamUtil.getLong((Object)folder, (PortletRequest)portletRequest, (String)"folderId", (long)rootFolderId);
        if (folderId != 0L) {
            try {
                folder = this._bookmarksFolderService.getFolder(folderId);
            }
            catch (NoSuchFolderException nsfe) {
                folder = null;
            }
            catch (PortalException pe) {
                _log.error((Object)pe, (Throwable)pe);
            }
        }
        return folder;
    }

    private long _getFolderId(BookmarksFolder folder) {
        long folderId = 0L;
        if (folder != null) {
            folderId = folder.getFolderId();
        }
        return folderId;
    }
}

