/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.configuration.icon;

import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.trash.TrashHelper;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "path=/bookmarks/view_folder"}, service={PortletConfigurationIcon.class})
public class DeleteFolderPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    @Reference(target="(model.class.name=com.liferay.bookmarks.model.BookmarksFolder)")
    private ModelResourcePermission<BookmarksFolder> _bookmarksFolderModelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;

    public String getMessage(PortletRequest portletRequest) {
        String key = "delete";
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
            key = "move-to-recycle-bin";
        }
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(themeDisplay.getLocale()), (String)key);
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        PortletURL deleteURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "ACTION_PHASE");
        deleteURL.setParameter("javax.portlet.action", "/bookmarks/edit_folder");
        String cmd = "delete";
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (this.isTrashEnabled(themeDisplay.getScopeGroupId())) {
            cmd = "move_to_trash";
        }
        deleteURL.setParameter("cmd", cmd);
        PortletURL parentFolderURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "RENDER_PHASE");
        BookmarksFolder folder = null;
        try {
            folder = ActionUtil.getFolder(portletRequest);
        }
        catch (Exception e) {
            return null;
        }
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId == 0L) {
            parentFolderURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
        } else {
            parentFolderURL.setParameter("mvcRenderCommandName", "/bookmarks/view_folder");
            parentFolderURL.setParameter("folderId", String.valueOf(parentFolderId));
        }
        deleteURL.setParameter("redirect", parentFolderURL.toString());
        deleteURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        return deleteURL.toString();
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        try {
            BookmarksFolder folder = ActionUtil.getFolder(portletRequest);
            if (folder == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (this._bookmarksFolderModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)folder, "DELETE")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean isTrashEnabled(long groupId) {
        try {
            if (this._trashHelper.isTrashEnabled(groupId)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

