/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.bookmarks.exception.NoSuchEntryException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.service.BookmarksEntryService;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/bookmarks/open_entry"}, service={StrutsAction.class})
public class OpenEntryAction
extends BaseStrutsAction {
    private BookmarksEntryService _bookmarksEntryService;
    @Reference
    private Portal _portal;

    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            int status;
            long entryId = ParamUtil.getLong((HttpServletRequest)request, (String)"entryId");
            BookmarksEntry entry = this._bookmarksEntryService.getEntry(entryId);
            if (entry.isInTrash() && (status = ParamUtil.getInteger((HttpServletRequest)request, (String)"status", (int)0)) != 8) {
                throw new NoSuchEntryException("{entryId=" + entryId + "}");
            }
            entry = this._bookmarksEntryService.openEntry(entry);
            response.sendRedirect(entry.getUrl());
            return null;
        }
        catch (Exception e) {
            this._portal.sendError(e, request, response);
            return null;
        }
    }

    @Reference(unbind="-")
    protected void setBookmarksEntryService(BookmarksEntryService bookmarksEntryService) {
        this._bookmarksEntryService = bookmarksEntryService;
    }
}

