/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.bookmarks.exception.NoSuchEntryException;
import com.liferay.bookmarks.model.BookmarksEntry;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;

@Component(property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "mvc.command.name=/bookmarks/move_entry"}, service={MVCRenderCommand.class})
public class MoveEntryMVCRenderCommand
implements MVCRenderCommand {
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            List<BookmarksEntry> entries = ActionUtil.getEntries((PortletRequest)renderRequest);
            renderRequest.setAttribute("BOOKMARKS_ENTRIES", entries);
            BookmarksEntry entry = ActionUtil.getEntry((PortletRequest)renderRequest);
            renderRequest.setAttribute("BOOKMARKS_ENTRY", (Object)entry);
            List<BookmarksFolder> folders = ActionUtil.getFolders((PortletRequest)renderRequest);
            renderRequest.setAttribute("BOOKMARKS_FOLDERS", folders);
        }
        catch (Exception e) {
            if (e instanceof NoSuchEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/bookmarks/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return "/bookmarks/move_entries.jsp";
    }
}

