/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.bookmarks.exception.FolderNameException;
import com.liferay.bookmarks.exception.NoSuchFolderException;
import com.liferay.bookmarks.model.BookmarksFolder;
import com.liferay.bookmarks.service.BookmarksFolderService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.trash.service.TrashEntryService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksPortlet", "javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet", "mvc.command.name=/bookmarks/edit_folder"}, service={MVCActionCommand.class})
public class EditFolderMVCActionCommand
extends BaseMVCActionCommand {
    private BookmarksFolderService _bookmarksFolderService;
    private TrashEntryService _trashEntryService;

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ArrayList<BookmarksFolder> trashedModels = new ArrayList<BookmarksFolder>();
        for (long deleteFolderId : deleteFolderIds) {
            if (moveToTrash) {
                BookmarksFolder folder = this._bookmarksFolderService.moveFolderToTrash(deleteFolderId);
                trashedModels.add(folder);
                continue;
            }
            this._bookmarksFolderService.deleteFolder(deleteFolderId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<BookmarksFolder>> data = new HashMap<String, ArrayList<BookmarksFolder>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreTrashEntries(actionRequest);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/bookmarks/error.jsp");
            }
            if (e instanceof FolderNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    protected void restoreTrashEntries(ActionRequest actionRequest) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    @Reference(unbind="-")
    protected void setBookmarksFolderService(BookmarksFolderService bookmarksFolderService) {
        this._bookmarksFolderService = bookmarksFolderService;
    }

    @Reference(unbind="-")
    protected void setTrashEntryService(TrashEntryService trashEntryService) {
        this._trashEntryService = trashEntryService;
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._bookmarksFolderService.subscribeFolder(themeDisplay.getScopeGroupId(), folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._bookmarksFolderService.unsubscribeFolder(themeDisplay.getScopeGroupId(), folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean mergeWithParentFolder = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)BookmarksFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            this._bookmarksFolderService.addFolder(parentFolderId, name, description, serviceContext);
        } else if (mergeWithParentFolder) {
            this._bookmarksFolderService.mergeFolders(folderId, parentFolderId);
        } else {
            this._bookmarksFolderService.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        }
    }
}

