/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.portlet.action;

import com.liferay.bookmarks.service.BookmarksFolderLocalService;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.BaseJSPSettingsConfigurationAction;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet"}, service={ConfigurationAction.class})
public class BookmarksAdminConfigurationAction
extends BaseJSPSettingsConfigurationAction {
    private static final Log _log = LogFactoryUtil.getLog(BookmarksAdminConfigurationAction.class);
    @Reference
    private BookmarksFolderLocalService _bookmarksFolderLocalService;

    public String getJspPath(HttpServletRequest request) {
        return "/bookmarks_admin/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.validateEmail(actionRequest, "emailMessageAdded");
        this.validateEmail(actionRequest, "emailMessageUpdated");
        this.validateEmailFrom(actionRequest);
        this.validateRootFolder(actionRequest);
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.bookmarks.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void validateRootFolder(ActionRequest actionRequest) throws Exception {
        long rootFolderId = GetterUtil.getLong((String)this.getParameter((PortletRequest)actionRequest, "rootFolderId"));
        if (rootFolderId != 0L) {
            try {
                this._bookmarksFolderLocalService.getFolder(rootFolderId);
            }
            catch (NoSuchFolderException nsfe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)nsfe, (Throwable)nsfe);
                }
                SessionErrors.add((PortletRequest)actionRequest, (String)"rootFolderIdInvalid");
            }
        }
    }
}

