/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.bookmarks.web.internal.display.context;

import com.liferay.bookmarks.configuration.BookmarksGroupServiceOverriddenConfiguration;
import com.liferay.bookmarks.service.BookmarksFolderServiceUtil;
import com.liferay.bookmarks.web.internal.portlet.toolbar.contributor.BookmarksPortletToolbarContributor;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class BookmarksManagementToolbarDisplayContext {
    private final BookmarksGroupServiceOverriddenConfiguration _bookmarksGroupServiceOverriddenConfiguration;
    private final long _folderId;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private final SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public BookmarksManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest request, BookmarksGroupServiceOverriddenConfiguration bookmarksGroupServiceOverriddenConfiguration, PortalPreferences portalPreferences, TrashHelper trashHelper) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = request;
        this._bookmarksGroupServiceOverriddenConfiguration = bookmarksGroupServiceOverriddenConfiguration;
        this._portalPreferences = portalPreferences;
        this._trashHelper = trashHelper;
        this._folderId = GetterUtil.getLong((String)((String)this._request.getAttribute("view.jsp-folderId")));
        this._searchContainer = (SearchContainer)this._request.getAttribute("view.jsp-bookmarksSearchContainer");
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    if (BookmarksManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(BookmarksManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId())) {
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BookmarksManagementToolbarDisplayContext.this._request, (String)"move-to-recycle-bin"));
                    } else {
                        dropdownItem.setIcon("times");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BookmarksManagementToolbarDisplayContext.this._request, (String)"delete"));
                    }
                    dropdownItem.setQuickAction(true);
                }));
            }
        };
    }

    public String getClearResultsURL() {
        return String.valueOf(this._getPortletURL());
    }

    public CreationMenu getCreationMenu() {
        String portletName = this._liferayPortletRequest.getPortletName();
        if (!portletName.equals("com_liferay_bookmarks_web_portlet_BookmarksAdminPortlet")) {
            return null;
        }
        BookmarksPortletToolbarContributor bookmarksPortletToolbarContributor = (BookmarksPortletToolbarContributor)((Object)this._request.getAttribute("BOOKMARKS_PORTLET_TOOLBAR_CONTRIBUTOR"));
        List menus = bookmarksPortletToolbarContributor.getPortletTitleMenus((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        if (menus.isEmpty()) {
            return null;
        }
        CreationMenu creationMenu = new CreationMenu();
        for (Menu menu : menus) {
            List urlMenuItems = menu.getMenuItems();
            for (URLMenuItem urlMenuItem : urlMenuItems) {
                creationMenu.addDropdownItem(dropdownItem -> {
                    dropdownItem.setHref((Object)urlMenuItem.getURL());
                    dropdownItem.setLabel(urlMenuItem.getLabel());
                });
            }
        }
        return creationMenu;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(SafeConsumer.ignore(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(BookmarksManagementToolbarDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)BookmarksManagementToolbarDisplayContext.this._request, (String)"filter-by-navigation"));
                }));
            }
        };
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this._liferayPortletResponse.createRenderURL();
        searchActionURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
        searchActionURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._request));
        searchActionURL.setParameter("folderId", String.valueOf(this._folderId));
        return searchActionURL.toString();
    }

    public String getSearchContainerId() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"searchContainerId");
    }

    public int getTotalItems() {
        return this._searchContainer.getTotal();
    }

    public ViewTypeItemList getViewTypes() {
        int curEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"curEntry");
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"deltaEntry");
        String displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_bookmarks_web_portlet_BookmarksPortlet", "display-style", "descriptive");
        }
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        PortletURL displayStyleURL = this._liferayPortletResponse.createRenderURL();
        if (Validator.isNull((String)keywords)) {
            if (this._folderId == 0L) {
                displayStyleURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
            } else {
                displayStyleURL.setParameter("mvcRenderCommandName", "/bookmarks/view_folder");
                displayStyleURL.setParameter("folderId", String.valueOf(this._folderId));
            }
        } else {
            displayStyleURL.setParameter("mvcRenderCommandName", "/bookmarks/view");
            displayStyleURL.setParameter("folderId", String.valueOf(this._folderId));
        }
        displayStyleURL.setParameter("navigation", HtmlUtil.escapeJS((String)this._getNavigation()));
        if (curEntry > 0) {
            displayStyleURL.setParameter("curEntry", String.valueOf(curEntry));
        }
        if (deltaEntry > 0) {
            displayStyleURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        return new ViewTypeItemList(displayStyleURL, displayStyle){
            {
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabled() {
        int foldersAndEntriesCount = BookmarksFolderServiceUtil.getFoldersAndEntriesCount((long)this._themeDisplay.getScopeGroupId(), (long)this._folderId);
        String navigation = this._getNavigation();
        return foldersAndEntriesCount == 0 && navigation.equals("all");
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isShowSearch() {
        return this._bookmarksGroupServiceOverriddenConfiguration.showFoldersSearch();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                String[] navigationKeys = null;
                navigationKeys = BookmarksManagementToolbarDisplayContext.this._themeDisplay.isSignedIn() ? new String[]{"all", "recent", "mine"} : new String[]{"all", "recent"};
                PortletURL portletURL = BookmarksManagementToolbarDisplayContext.this._getPortletURL();
                portletURL.setParameter("folderId", String.valueOf(0L));
                for (String navigationKey : navigationKeys) {
                    this.add(SafeConsumer.ignore(dropdownItem -> {
                        dropdownItem.setActive(navigationKey.equals(BookmarksManagementToolbarDisplayContext.this._getNavigation()));
                        PortletURL navigationURL = PortletURLUtil.clone((PortletURL)portletURL, (LiferayPortletResponse)BookmarksManagementToolbarDisplayContext.this._liferayPortletResponse);
                        dropdownItem.setHref(navigationURL, new Object[]{"navigation", navigationKey});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)BookmarksManagementToolbarDisplayContext.this._request, (String)navigationKey));
                    }));
                }
            }
        };
    }

    private String _getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
    }

    private PortletURL _getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("categoryId", "");
        int deltaEntry = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"deltaEntry");
        if (deltaEntry > 0) {
            portletURL.setParameter("deltaEntry", String.valueOf(deltaEntry));
        }
        portletURL.setParameter("folderId", String.valueOf(this._folderId));
        portletURL.setParameter("tag", "");
        return portletURL;
    }
}

