/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class BatchEngineImportTaskItemReaderUtil {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskItemReaderUtil.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, (JsonDeserializer)new MapStdDeserializer());
            this.registerModule((Module)simpleModule);
        }
    };

    public static <T> T convertValue(Class<T> itemClass, Map<String, Object> fieldNameValueMap) throws ReflectiveOperationException {
        T item = itemClass.newInstance();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String name = entry.getKey();
            Field field = null;
            for (Field declaredField : itemClass.getDeclaredFields()) {
                if (!name.equals(declaredField.getName()) && !Objects.equals("_" + name, declaredField.getName())) continue;
                field = declaredField;
                break;
            }
            if (field != null) {
                field.setAccessible(true);
                field.set(item, _objectMapper.convertValue(entry.getValue(), field.getType()));
                continue;
            }
            for (Field declaredField : itemClass.getDeclaredFields()) {
                JsonAnySetter[] jsonAnySetters = (JsonAnySetter[])declaredField.getAnnotationsByType(JsonAnySetter.class);
                if (jsonAnySetters.length <= 0) continue;
                field = declaredField;
                break;
            }
            if (field == null) {
                throw new NoSuchFieldException(entry.getKey());
            }
            field.setAccessible(true);
            Map map = (Map)field.get(item);
            map.put(entry.getKey(), entry.getValue());
        }
        return item;
    }

    public static Map<String, Object> mapFieldNames(Map<String, ? extends Serializable> fieldNameMappingMap, Map<String, Object> fieldNameValueMap) {
        if (fieldNameMappingMap == null || fieldNameMappingMap.isEmpty()) {
            return fieldNameValueMap;
        }
        HashMap<String, Object> targetFieldNameValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String targetFieldName = (String)((Object)fieldNameMappingMap.get(entry.getKey()));
            if (!Validator.isNotNull((String)targetFieldName)) continue;
            Object object = targetFieldNameValueMap.get(targetFieldName);
            if (object != null && object instanceof Map) {
                Map map = (Map)object;
                map.putAll((Map)entry.getValue());
                continue;
            }
            targetFieldNameValueMap.put(targetFieldName, entry.getValue());
        }
        return targetFieldNameValueMap;
    }

    private static class MapStdDeserializer
    extends StdDeserializer<Map<String, Object>> {
        public MapStdDeserializer() {
            this(Map.class);
        }

        public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                return (Map)deserializationContext.readValue(jsonParser, LinkedHashMap.class);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                String string = jsonParser.getValueAsString();
                for (String line : string.split("\r\n")) {
                    String[] lineParts = line.split(":");
                    map.put(lineParts[0], lineParts[1]);
                }
                return map;
            }
        }

        protected MapStdDeserializer(Class<?> clazz) {
            super(clazz);
        }
    }
}

