/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.messaging;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, immediate=true, service={MessageListener.class})
public class BatchEngineTaskOrphanScannerMessageListener
extends BaseMessageListener {
    @Reference
    private BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private long _orphanageThreshold;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._orphanageThreshold = (long)batchEngineTaskConfiguration.orphanageThreshold() * 60000L;
        String className = BatchEngineTaskOrphanScannerMessageListener.class.getName();
        int scanInterval = batchEngineTaskConfiguration.orphanScanInterval();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, scanInterval, TimeUnit.MINUTE);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)new SchedulerEntryImpl(className, trigger), "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineTaskOrphanScannerMessageListener.class.getName(), false);
        if (executorService != null) {
            executorService.shutdownNow();
        }
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) {
        Date modifiedDate;
        NoticeableExecutorService noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(BatchEngineTaskOrphanScannerMessageListener.class.getName());
        long time = System.currentTimeMillis();
        for (BatchEngineExportTask batchEngineExportTask : this._batchEngineExportTaskLocalService.getBatchEngineExportTasks(BatchEngineTaskExecuteStatus.STARTED.toString())) {
            modifiedDate = batchEngineExportTask.getModifiedDate();
            if (time - modifiedDate.getTime() <= this._orphanageThreshold) continue;
            noticeableExecutorService.submit(() -> this._batchEngineExportTaskExecutor.execute(batchEngineExportTask));
        }
        for (BatchEngineImportTask batchEngineImportTask : this._batchEngineImportTaskLocalService.getBatchEngineImportTasks(BatchEngineTaskExecuteStatus.STARTED.toString())) {
            modifiedDate = batchEngineImportTask.getModifiedDate();
            if (time - modifiedDate.getTime() <= this._orphanageThreshold) continue;
            noticeableExecutorService.submit(() -> this._batchEngineImportTaskExecutor.execute(batchEngineImportTask));
        }
    }
}

