/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.messaging;

import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, immediate=true, service={MessageListener.class})
public class BatchEngineTaskCleanerMessageListener
extends BaseMessageListener {
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        String className = BatchEngineTaskCleanerMessageListener.class.getName();
        int scanInterval = batchEngineTaskConfiguration.completedTasksCleanerScanInterval();
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, scanInterval, TimeUnit.DAY);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)new SchedulerEntryImpl(className, trigger), "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        for (BatchEngineExportTask batchEngineExportTask : this._batchEngineExportTaskLocalService.getBatchEngineExportTasks(BatchEngineTaskExecuteStatus.COMPLETED.toString())) {
            this._batchEngineExportTaskLocalService.deleteBatchEngineExportTask(batchEngineExportTask.getBatchEngineExportTaskId());
        }
        for (BatchEngineImportTask batchEngineImportTask : this._batchEngineImportTaskLocalService.getBatchEngineImportTasks(BatchEngineTaskExecuteStatus.COMPLETED.toString())) {
            this._batchEngineImportTaskLocalService.deleteBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
        }
    }
}

