/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ColumnValuesExtractor {
    private static final Log _log = LogFactoryUtil.getLog(ColumnValuesExtractor.class);
    private final List<UnsafeFunction<Object, Object, ReflectiveOperationException>> _unsafeFunctions;

    public ColumnValuesExtractor(Map<String, Field> fieldMap, List<String> fieldNames) {
        this._unsafeFunctions = new ArrayList<UnsafeFunction<Object, Object, ReflectiveOperationException>>(fieldNames.size());
        for (String fieldName : fieldNames) {
            this._addUnsafeFunction(fieldMap, fieldName);
        }
    }

    public List<Object> extractValues(Object item) throws ReflectiveOperationException {
        ArrayList<Object> values = new ArrayList<Object>(this._unsafeFunctions.size());
        for (UnsafeFunction<Object, Object, ReflectiveOperationException> unsafeFunction : this._unsafeFunctions) {
            values.add(unsafeFunction.apply(item));
        }
        return values;
    }

    private void _addUnsafeFunction(Map<String, Field> fieldMap, String fieldName) {
        Field field = fieldMap.get(fieldName);
        if (field != null) {
            Class<?> fieldClass = field.getType();
            if (ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass)) {
                this._unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
                    if (field.get(item) == null) {
                        return "";
                    }
                    return field.get(item);
                }));
                return;
            }
            if (ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass)) {
                if (!Objects.equals(fieldClass.getComponentType(), String.class)) {
                    this._unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
                        if (field.get(item) == null) {
                            return "";
                        }
                        return CSVUtil.encode((Object)field.get(item));
                    }));
                    return;
                }
                this._unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
                    if (field.get(item) == null) {
                        return "";
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try (CSVPrinter csvPrinter = new CSVPrinter((Appendable)new OutputStreamWriter(byteArrayOutputStream), CSVFormat.DEFAULT);){
                        csvPrinter.print((Object)StringUtil.merge((Object[])((String[])field.get(item)), value -> CSVUtil.encode((String)value), (String)","));
                    }
                    catch (IOException ioException) {
                        _log.error((Object)"Unable to export array to column", (Throwable)ioException);
                        return "";
                    }
                    return new String(byteArrayOutputStream.toByteArray());
                }));
                return;
            }
            this._unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> ""));
            return;
        }
        int index = fieldName.indexOf(95);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid field name : " + fieldName);
        }
        String prefixFieldName = fieldName.substring(0, index);
        Field mapField = fieldMap.get(prefixFieldName);
        if (mapField == null) {
            throw new IllegalArgumentException("Invalid field name : " + fieldName);
        }
        if (mapField.getType() != Map.class) {
            throw new IllegalArgumentException("Invalid field name : " + fieldName + ", it is not Map type.");
        }
        String key = fieldName.substring(index + 1);
        this._unsafeFunctions.add((UnsafeFunction<Object, Object, ReflectiveOperationException>)((UnsafeFunction)item -> {
            Map map = (Map)mapField.get(item);
            Object value = map.get(key);
            if (value == null) {
                return "";
            }
            return value;
        }));
    }
}

