/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.upgrade.v4_6_1;

import com.liferay.batch.engine.configuration.BatchEngineTaskCompanyConfiguration;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class BatchEngineTaskConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final String _CSV_FILE_COLUMN_DELIMITER = "csvFileColumnDelimiter";
    private static final String _EXPORT_BATCH_SIZE = "exportBatchSize";
    private static final String _IMPORT_BATCH_SIZE = "importBatchSize";
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationAdmin _configurationAdmin;
    private final ConfigurationProvider _configurationProvider;

    public BatchEngineTaskConfigurationUpgradeProcess(CompanyLocalService companyLocalService, ConfigurationAdmin configurationAdmin, ConfigurationProvider configurationProvider) {
        this._companyLocalService = companyLocalService;
        this._configurationAdmin = configurationAdmin;
        this._configurationProvider = configurationProvider;
    }

    protected void doUpgrade() throws Exception {
        Configuration configuration = this._configurationAdmin.getConfiguration("com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration", "?");
        Dictionary properties = configuration.getProperties();
        if (properties == null) {
            return;
        }
        this._createCompanyConfigurations(properties);
        properties.remove(_CSV_FILE_COLUMN_DELIMITER);
        properties.remove(_EXPORT_BATCH_SIZE);
        properties.remove(_IMPORT_BATCH_SIZE);
        configuration.update(properties);
    }

    private void _createCompanyConfigurations(Dictionary<String, Object> properties) throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> this._configurationProvider.saveCompanyConfiguration(BatchEngineTaskCompanyConfiguration.class, companyId.longValue(), (Dictionary)HashMapDictionaryBuilder.put((Object)_CSV_FILE_COLUMN_DELIMITER, properties.get(_CSV_FILE_COLUMN_DELIMITER)).put((Object)_EXPORT_BATCH_SIZE, properties.get(_EXPORT_BATCH_SIZE)).put((Object)_IMPORT_BATCH_SIZE, properties.get(_IMPORT_BATCH_SIZE)).build()));
    }
}

