/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReaderUtil;
import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class CSVBatchEngineImportTaskItemReader
implements BatchEngineImportTaskItemReader {
    private final String _delimiter;
    private final String[] _fieldNames;
    private final InputStream _inputStream;
    private final UnsyncBufferedReader _unsyncBufferedReader;

    public CSVBatchEngineImportTaskItemReader(String delimiter, InputStream inputStream) throws IOException {
        this._delimiter = delimiter;
        this._inputStream = inputStream;
        this._unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(this._inputStream));
        this._fieldNames = StringUtil.split((String)this._unsyncBufferedReader.readLine(), (String)delimiter);
    }

    @Override
    public void close() throws IOException {
        this._unsyncBufferedReader.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        String line = this._unsyncBufferedReader.readLine();
        if (line == null) {
            return null;
        }
        HashMap<String, Object> fieldNameValueMap = new HashMap<String, Object>();
        String[] values = StringUtil.split((String)line, (String)this._delimiter);
        for (int i = 0; i < values.length; ++i) {
            int lastDelimiterIndex;
            String fieldName = this._fieldNames[i];
            if (fieldName == null) continue;
            String value = values[i].trim();
            if (value.isEmpty()) {
                value = null;
            }
            if ((lastDelimiterIndex = fieldName.lastIndexOf(95)) == -1) {
                fieldNameValueMap.put(fieldName, value);
                continue;
            }
            BatchEngineImportTaskItemReaderUtil.handleMapField(fieldName, fieldNameValueMap, lastDelimiterIndex, value);
        }
        return fieldNameValueMap;
    }
}

