/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.CSVBatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.batch.engine.internal.writer.JSONBatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.JSONLBatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.XLSBatchEngineExportTaskItemWriter;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;

public class BatchEngineExportTaskItemWriterFactory {
    private final String _csvFileColumnDelimiter;

    public BatchEngineExportTaskItemWriterFactory(String csvFileColumnDelimiter) {
        this._csvFileColumnDelimiter = csvFileColumnDelimiter;
    }

    public BatchEngineExportTaskItemWriter create(BatchEngineTaskContentType batchEngineTaskContentType, List<String> fieldNames, Class<?> itemClass, OutputStream outputStream) throws Exception {
        Map<String, Field> fieldMap = ItemClassIndexUtil.index(itemClass);
        if (batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineExportTaskItemWriter(this._csvFileColumnDelimiter, fieldMap, fieldNames, outputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
            return new JSONBatchEngineExportTaskItemWriter(fieldMap.keySet(), fieldNames, outputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineExportTaskItemWriter(fieldMap.keySet(), fieldNames, outputStream);
        }
        if (batchEngineTaskContentType == BatchEngineTaskContentType.XLS || batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineExportTaskItemWriter(fieldMap, fieldNames, outputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + batchEngineTaskContentType);
    }
}

