/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.info.display.field.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.field.ClassTypesInfoDisplayFieldProvider;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class ClassTypesInfoDisplayFieldProviderUtil {
    private static final ServiceTracker<ClassTypesInfoDisplayFieldProvider, ClassTypesInfoDisplayFieldProvider> _serviceTracker;

    public static List<InfoDisplayField> getClassTypeInfoDisplayFields(String className, long classTypeId, Locale locale) throws PortalException {
        ClassTypesInfoDisplayFieldProvider classTypesInfoDisplayFieldProvider = (ClassTypesInfoDisplayFieldProvider)_serviceTracker.getService();
        ClassTypeReader classTypeReader = ClassTypesInfoDisplayFieldProviderUtil._getClassTypeReader(className);
        return classTypesInfoDisplayFieldProvider.getClassTypeInfoDisplayFields(classTypeReader.getClassType(classTypeId, locale), locale);
    }

    public static List<ClassType> getClassTypes(long groupId, String className, Locale locale) throws PortalException {
        ClassTypesInfoDisplayFieldProvider classTypesInfoDisplayFieldProvider = (ClassTypesInfoDisplayFieldProvider)_serviceTracker.getService();
        return classTypesInfoDisplayFieldProvider.getClassTypes(groupId, ClassTypesInfoDisplayFieldProviderUtil._getClassTypeReader(className), locale);
    }

    private static ClassTypeReader _getClassTypeReader(String className) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.isSupportsClassTypes()) {
            return null;
        }
        return assetRendererFactory.getClassTypeReader();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(ClassTypesInfoDisplayFieldProviderUtil.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), ClassTypesInfoDisplayFieldProvider.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

