/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.internal.contributor;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.AssetDisplayField;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.info.display.contributor.InfoDisplayObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AssetInfoDisplayContributorAdapter
implements InfoDisplayContributor<AssetEntry> {
    private final AssetDisplayContributor _assetDisplayContributor;

    public AssetInfoDisplayContributorAdapter(AssetDisplayContributor assetDisplayContributor) {
        this._assetDisplayContributor = assetDisplayContributor;
    }

    public String getClassName() {
        return this._assetDisplayContributor.getClassName();
    }

    public List<InfoDisplayField> getClassTypeInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        ArrayList<InfoDisplayField> infoDisplayFields = new ArrayList<InfoDisplayField>();
        List assetDisplayFields = this._assetDisplayContributor.getClassTypeFields(classTypeId, locale);
        for (AssetDisplayField assetDisplayField : assetDisplayFields) {
            InfoDisplayField infoDisplayField = new InfoDisplayField(assetDisplayField.getKey(), assetDisplayField.getLabel(), assetDisplayField.getType());
            infoDisplayFields.add(infoDisplayField);
        }
        return infoDisplayFields;
    }

    public List<ClassType> getClassTypes(long groupId, Locale locale) throws PortalException {
        return this._assetDisplayContributor.getClassTypes(groupId, locale);
    }

    public Set<InfoDisplayField> getInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        HashSet<InfoDisplayField> infoDisplayFields = new HashSet<InfoDisplayField>();
        Set assetDisplayFields = this._assetDisplayContributor.getAssetDisplayFields(classTypeId, locale);
        for (AssetDisplayField assetDisplayField : assetDisplayFields) {
            InfoDisplayField infoDisplayField = new InfoDisplayField(assetDisplayField.getKey(), assetDisplayField.getLabel(), assetDisplayField.getType());
            infoDisplayFields.add(infoDisplayField);
        }
        return infoDisplayFields;
    }

    public Map<String, Object> getInfoDisplayFieldsValues(AssetEntry assetEntry, Locale locale) throws PortalException {
        return this._assetDisplayContributor.getAssetDisplayFieldsValues(assetEntry, locale);
    }

    public Object getInfoDisplayFieldValue(AssetEntry assetEntry, String fieldName, Locale locale) throws PortalException {
        return this._assetDisplayContributor.getAssetDisplayFieldValue(assetEntry, fieldName, locale);
    }

    public InfoDisplayObjectProvider getInfoDisplayObjectProvider(long classPK) throws PortalException {
        return this._assetDisplayContributor.getInfoDisplayObjectProvider(classPK);
    }

    public InfoDisplayObjectProvider<AssetEntry> getInfoDisplayObjectProvider(long groupId, String urlTitle) throws PortalException {
        return this._assetDisplayContributor.getInfoDisplayObjectProvider(groupId, urlTitle);
    }

    public String getInfoURLSeparator() {
        return this._assetDisplayContributor.getAssetURLSeparator();
    }

    public String getLabel(Locale locale) {
        return this._assetDisplayContributor.getLabel(locale);
    }

    public Map<String, Object> getVersionInfoDisplayFieldsValues(AssetEntry assetEntry, long versionClassPK, Locale locale) throws PortalException {
        return this._assetDisplayContributor.getAssetDisplayFieldsValues(assetEntry, versionClassPK, locale);
    }
}

