/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePanelApp
implements PanelApp {
    protected GroupProvider groupProvider;
    private static final Log _log = LogFactoryUtil.getLog(BasePanelApp.class);
    private Portlet _portlet;
    private PortletLocalService _portletLocalService;
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    @Override
    public String getKey() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public String getLabel(Locale locale) {
        try {
            return LanguageUtil.get((Locale)locale, (String)("javax.portlet.title." + this.getPortletId()));
        }
        catch (MissingResourceException missingResourceException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)missingResourceException, (Throwable)missingResourceException);
            }
            return LanguageUtil.get((Locale)locale, (String)("javax.portlet.title." + this.getPortletId()));
        }
    }

    @Override
    public int getNotificationsCount(User user) {
        if (this._userNotificationEventLocalService == null) {
            return 0;
        }
        return this._userNotificationEventLocalService.getUserNotificationEventsCount(user.getUserId(), this._portlet.getPortletId(), 10002, true, false);
    }

    @Override
    public Portlet getPortlet() {
        return this._portlet;
    }

    @Override
    public PortletURL getPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)httpServletRequest, (Group)this.getGroup(httpServletRequest), (String)this.getPortletId(), (long)0L, (long)0L, (String)"RENDER_PHASE");
        Group group = this.groupProvider.getGroup(httpServletRequest);
        if (group == null) {
            return portletURL;
        }
        portletURL.setParameter("p_v_l_s_g_id", String.valueOf(group.getGroupId()));
        return portletURL;
    }

    @Override
    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return false;
    }

    @Override
    public boolean isShow(PermissionChecker permissionChecker, Group group) throws PortalException {
        Portlet portlet = this._portletLocalService.getPortletById(group.getCompanyId(), this.getPortletId());
        if (!portlet.isActive()) {
            return false;
        }
        try {
            ControlPanelEntry controlPanelEntry = this.getControlPanelEntry();
            if (controlPanelEntry == null) {
                return true;
            }
            return controlPanelEntry.hasAccessPermission(permissionChecker, group, this.getPortlet());
        }
        catch (PortalException | RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    @Override
    public void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    @Override
    public void setPortlet(Portlet portlet) {
        this._portlet = portlet;
    }

    protected ControlPanelEntry getControlPanelEntry() {
        Portlet portlet = this.getPortlet();
        if (portlet == null) {
            return null;
        }
        return portlet.getControlPanelEntryInstance();
    }

    protected Group getGroup(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (!group.isControlPanel()) {
            return null;
        }
        Portlet portlet = this.getPortlet();
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (Validator.isNull((String)controlPanelEntryCategory) || !controlPanelEntryCategory.startsWith("site_administration.") || this.groupProvider == null) {
            return null;
        }
        return this.groupProvider.getGroup(httpServletRequest);
    }

    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }

    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

