/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.BasePanelApp;
import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelCategory;
import com.liferay.osgi.service.tracker.collections.ServiceReferenceServiceTuple;
import com.liferay.osgi.service.tracker.collections.ServiceTrackerMapBuilder;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucket;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerBucketFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PanelAppRegistry.class})
public class PanelAppRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PanelAppRegistry.class);
    @Reference
    private GroupProvider _groupProvider;
    @Reference
    private PortletLocalService _portletLocalService;
    private ServiceTrackerMap<String, List<PanelApp>> _serviceTrackerMap;

    public PanelApp getFirstPanelApp(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        for (PanelApp panelApp : panelApps) {
            try {
                if (!panelApp.isShow(permissionChecker, group)) continue;
                return panelApp;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return null;
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory) {
        return this.getPanelApps(parentPanelCategory.getKey());
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory, PermissionChecker permissionChecker, Group group) {
        return this.getPanelApps(parentPanelCategory.getKey(), permissionChecker, group);
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey) {
        List panelApps = (List)this._serviceTrackerMap.getService((Object)parentPanelCategoryKey);
        if (panelApps == null) {
            return Collections.emptyList();
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        return ListUtil.filter((List)panelApps, panelApp -> {
            Portlet portlet = panelApp.getPortlet();
            if (portlet == null) {
                portlet = this._portletLocalService.getPortletById(panelApp.getPortletId());
                panelApp.setPortlet(portlet);
            }
            if (portlet == null) {
                return false;
            }
            long portletCompanyId = portlet.getCompanyId();
            return portletCompanyId == 0L || portletCompanyId == companyId;
        });
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        if (panelApps.isEmpty()) {
            return panelApps;
        }
        return ListUtil.filter(panelApps, panelApp -> {
            try {
                return panelApp.isShow(permissionChecker, group);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        });
    }

    public int getPanelAppsNotificationsCount(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = 0;
        for (PanelApp panelApp : this.getPanelApps(parentPanelCategoryKey)) {
            int notificationsCount = panelApp.getNotificationsCount(user);
            try {
                if (notificationsCount <= 0 || !panelApp.isShow(permissionChecker, group)) continue;
                count += notificationsCount;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return count;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapBuilder.SelectorFactory.newSelector((BundleContext)bundleContext, PanelApp.class).map("panel.category.key").collect((ServiceTrackerBucketFactory)new PanelAppsServiceTrackerBucketFactory()).newCollector((ServiceTrackerMapListener)new PanelAppsServiceTrackerMapListener()).build();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private class PanelAppsServiceTrackerMapListener
    implements ServiceTrackerMapListener<String, PanelApp, List<PanelApp>> {
        private PanelAppsServiceTrackerMapListener() {
        }

        public void keyEmitted(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
            panelApp.setGroupProvider(PanelAppRegistry.this._groupProvider);
            Portlet portlet = PanelAppRegistry.this._portletLocalService.getPortletById(panelApp.getPortletId());
            if (portlet != null) {
                portlet.setControlPanelEntryCategory(panelCategoryKey);
                panelApp.setPortlet(portlet);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to get portlet " + panelApp.getPortletId()));
            }
            if (panelApp instanceof BasePanelApp) {
                BasePanelApp basePanelApp = (BasePanelApp)panelApp;
                basePanelApp.setPortletLocalService(PanelAppRegistry.this._portletLocalService);
            }
        }

        public void keyRemoved(ServiceTrackerMap<String, List<PanelApp>> serviceTrackerMap, String panelCategoryKey, PanelApp panelApp, List<PanelApp> panelApps) {
        }
    }

    private class PanelAppsServiceTrackerBucketFactory
    implements ServiceTrackerBucketFactory<PanelApp, PanelApp, List<PanelApp>> {
        private PanelAppsServiceTrackerBucketFactory() {
        }

        public ServiceTrackerBucket<PanelApp, PanelApp, List<PanelApp>> create() {
            return new PanelCategoryServiceTrackerBucket();
        }

        private class PanelCategoryServiceTrackerBucket
        implements ServiceTrackerBucket<PanelApp, PanelApp, List<PanelApp>> {
            private final Comparator<ServiceReferenceServiceTuple<PanelApp, PanelApp>> _comparator;
            private final List<ServiceReferenceServiceTuple<PanelApp, PanelApp>> _serviceReferenceServiceTuples;
            private List<PanelApp> _services;

            private PanelCategoryServiceTrackerBucket() {
                this._comparator = Comparator.comparing(ServiceReferenceServiceTuple::getServiceReference, new PanelAppOrderComparator());
                this._serviceReferenceServiceTuples = new ArrayList<ServiceReferenceServiceTuple<PanelApp, PanelApp>>();
                this._services = new ArrayList<PanelApp>();
            }

            public List<PanelApp> getContent() {
                return this._services;
            }

            public synchronized boolean isDisposable() {
                return this._serviceReferenceServiceTuples.isEmpty();
            }

            public synchronized void remove(ServiceReferenceServiceTuple<PanelApp, PanelApp> serviceReferenceServiceTuple) {
                this._serviceReferenceServiceTuples.remove(serviceReferenceServiceTuple);
                this._rebuild();
            }

            public synchronized void store(ServiceReferenceServiceTuple<PanelApp, PanelApp> serviceReferenceServiceTuple) {
                int index = Collections.binarySearch(this._serviceReferenceServiceTuples, serviceReferenceServiceTuple, this._comparator);
                if (index < 0) {
                    index = -index - 1;
                }
                this._serviceReferenceServiceTuples.add(index, serviceReferenceServiceTuple);
                this._rebuild();
            }

            private void _rebuild() {
                if (this._serviceReferenceServiceTuples.isEmpty()) {
                    this._services = Collections.emptyList();
                    return;
                }
                if (this._serviceReferenceServiceTuples.size() == 1) {
                    ServiceReferenceServiceTuple<PanelApp, PanelApp> serviceReferenceServiceTuple = this._serviceReferenceServiceTuples.get(0);
                    this._services = Arrays.asList((PanelApp)serviceReferenceServiceTuple.getService());
                    return;
                }
                LinkedHashMap panelApps = new LinkedHashMap();
                this._serviceReferenceServiceTuples.forEach(erviceReferenceServiceTuple -> {
                    PanelApp panelApp = (PanelApp)erviceReferenceServiceTuple.getService();
                    panelApps.putIfAbsent(panelApp.getKey(), panelApp);
                });
                this._services = new ArrayList(panelApps.values());
            }
        }
    }

    private class PanelAppOrderComparator
    implements Comparator<ServiceReference<PanelApp>>,
    Serializable {
        private PanelAppOrderComparator() {
        }

        @Override
        public int compare(ServiceReference serviceReference1, ServiceReference serviceReference2) {
            if (serviceReference1 == null) {
                if (serviceReference2 == null) {
                    return 0;
                }
                return 1;
            }
            if (serviceReference2 == null) {
                return -1;
            }
            Object propertyValue1 = serviceReference1.getProperty("panel.app.order");
            Object propertyValue2 = serviceReference2.getProperty("panel.app.order");
            if (propertyValue1 == null) {
                if (propertyValue2 == null) {
                    return 0;
                }
                return 1;
            }
            if (propertyValue2 == null) {
                return -1;
            }
            if (!(propertyValue2 instanceof Comparable)) {
                return -serviceReference2.compareTo((Object)serviceReference1);
            }
            Comparable propertyValueComparable2 = (Comparable)propertyValue2;
            return -propertyValueComparable2.compareTo(propertyValue1);
        }
    }
}

