Liferay.Loader.define('app-builder-web$moment@2.24.0/src/lib/units/quarter', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import { addFormatToken } from '../format/format';
        import { addUnitAlias } from './aliases';
        import { addUnitPriority } from './priorities';
        import { addRegexToken, match1 } from '../parse/regex';
        import { addParseToken } from '../parse/token';
        import { MONTH } from './constants';
        import toInt from '../utils/to-int';

        // FORMATTING

        addFormatToken('Q', 0, 'Qo', 'quarter');

        // ALIASES

        addUnitAlias('quarter', 'Q');

        // PRIORITY

        addUnitPriority('quarter', 7);

        // PARSING

        addRegexToken('Q', match1);
        addParseToken('Q', function (input, array) {
            array[MONTH] = (toInt(input) - 1) * 3;
        });

        // MOMENTS

        export function getSetQuarter(input) {
            return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
        }
    }
});
//# sourceMappingURL=quarter.js.map