Liferay.Loader.define('app-builder-web$lodash-es@4.17.15/_createCompounder', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import arrayReduce from './_arrayReduce.js';
    import deburr from './deburr.js';
    import words from './words.js';

    /** Used to compose unicode capture groups. */
    var rsApos = "['\u2019]";

    /** Used to match apostrophes. */
    var reApos = RegExp(rsApos, 'g');

    /**
     * Creates a function like `_.camelCase`.
     *
     * @private
     * @param {Function} callback The function to combine each word.
     * @returns {Function} Returns the new compounder function.
     */
    function createCompounder(callback) {
      return function (string) {
        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
      };
    }

    export default createCompounder;
  }
});
//# sourceMappingURL=_createCompounder.js.map