Liferay.Loader.define("app-builder-web@1.0.57/js/pages/table-view/TableViewFilters.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'data-engine-taglib', 'frontend-js-react-web$react', './EditTableViewContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.TableViewFiltersList = exports.FilterRenderer = exports.MultipleSelectFilter = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _EditTableViewContext = _interopRequireWildcard(require("./EditTableViewContext.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var MultipleSelectFilter = function MultipleSelectFilter(_ref) {
      var dataDefinitionField = _ref.dataDefinitionField,
          useFieldLabel = _ref.useFieldLabel;

      var _useContext = (0, _react.useContext)(_EditTableViewContext["default"]),
          _useContext2 = _slicedToArray(_useContext, 2),
          _useContext2$ = _useContext2[0],
          dataListView = _useContext2$.dataListView,
          editingLanguageId = _useContext2$.editingLanguageId,
          dispatch = _useContext2[1];

      var _dataDefinitionField$ = dataDefinitionField.customProperties.options,
          options = _dataDefinitionField$ === void 0 ? {} : _dataDefinitionField$,
          fieldLabel = dataDefinitionField.label,
          fieldName = dataDefinitionField.name;
      var localizedOptions = options[editingLanguageId] || [];
      var values = dataListView.appliedFilters[fieldName] || [];

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var onClickItem = function onClickItem(optionValue) {
        var newValue;

        if (values.includes(optionValue)) {
          newValue = values.filter(function (item) {
            return item !== optionValue;
          });
        } else {
          newValue = [].concat(_toConsumableArray(values), [optionValue]);
        }

        if (newValue.length) {
          dispatch({
            payload: {
              fieldName: fieldName,
              value: newValue
            },
            type: _EditTableViewContext.UPDATE_FILTER_VALUE
          });
        } else {
          dispatch({
            payload: {
              fieldName: fieldName
            },
            type: _EditTableViewContext.REMOVE_FILTER_VALUE
          });
        }
      };

      var alignElementRef = (0, _react.useRef)();
      var dropdownMenuRef = (0, _react.useRef)();

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          keywords = _useState4[0],
          setKeywords = _useState4[1];

      var searchRegex = new RegExp(keywords, 'ig');

      return _react["default"].createElement("div", {
        className: "multiple-select-filter table-view-filter"
      }, useFieldLabel ? _react["default"].createElement("label", null, fieldLabel[editingLanguageId] || fieldName) : _react["default"].createElement("label", null, Liferay.Language.get('filter-entries'), _react["default"].createElement("span", {
        className: "lfr-portal-tooltip tooltip-icon",
        "data-title": Liferay.Language.get('filter-entries-by-setting-a-value-for-this-column')
      }, _react["default"].createElement(_icon["default"], {
        symbol: "question-circle-full"
      }))), _react["default"].createElement(_button["default"], {
        className: (0, _classnames["default"])('multiple-select-filter-trigger', {
          empty: values.length === 0
        }),
        displayType: "secondary",
        onClick: function onClick() {
          return setActive(!active);
        },
        ref: alignElementRef
      }, _react["default"].createElement("span", {
        className: "multiple-select-filter-values"
      }, values.length === 0 ? Liferay.Language.get('choose-options') : localizedOptions.filter(function (_ref3) {
        var value = _ref3.value;
        return values.includes(value);
      }).map(function (_ref4) {
        var label = _ref4.label,
            value = _ref4.value;
        return label || value;
      }).join(', ')), _react["default"].createElement(_icon["default"], {
        symbol: "caret-bottom"
      })), _react["default"].createElement(_dropDown["default"].Menu, {
        active: active,
        alignElementRef: alignElementRef,
        alignmentPosition: _dropDown.Align.BottomCenter,
        autoBestAlign: true,
        className: "multiple-select-filter-dropdown",
        hasRightSymbols: true,
        onSetActive: function onSetActive(newVal) {
          return setActive(newVal);
        },
        ref: dropdownMenuRef
      }, _react["default"].createElement(_dropDown["default"].ItemList, {
        className: "multiple-select-filter-dropdown-items"
      }, _react["default"].createElement(_dropDown["default"].Item, {
        className: "dropdown-search",
        key: "search"
      }, _react["default"].createElement(_dataEngineTaglib.SearchInput, {
        onChange: setKeywords,
        searchText: keywords
      })), _react["default"].createElement(_dropDown["default"].Item, {
        className: (0, _classnames["default"])('dropdown-select-all', {
          clearable: values.length > 0
        }),
        key: "all"
      }, _react["default"].createElement(_button["default"], {
        className: "all text-secondary",
        displayType: "unstyled",
        onClick: function onClickSelectAll() {
          dispatch({
            payload: {
              fieldName: fieldName,
              value: localizedOptions.map(function (_ref2) {
                var value = _ref2.value;
                return value;
              })
            },
            type: _EditTableViewContext.UPDATE_FILTER_VALUE
          });
        }
      }, Liferay.Language.get('select-all')), values.length > 0 && _react["default"].createElement(_button["default"], {
        className: "clear text-secondary",
        displayType: "unstyled",
        onClick: function onClickClear() {
          dispatch({
            payload: {
              fieldName: fieldName
            },
            type: _EditTableViewContext.REMOVE_FILTER_VALUE
          });
        }
      }, Liferay.Language.get('clear'))), _react["default"].createElement(_dropDown["default"].Divider, null), localizedOptions.filter(function (_ref5) {
        var label = _ref5.label;
        return searchRegex.test(label);
      }).map(function (_ref6, index) {
        var label = _ref6.label,
            value = _ref6.value;
        return _react["default"].createElement(_dropDown["default"].Item, {
          key: index,
          onClick: function onClick(event) {
            event.preventDefault();
            onClickItem(value);
          },
          symbolRight: values.includes(value) ? 'check' : ''
        }, label || value);
      }))));
    };

    exports.MultipleSelectFilter = MultipleSelectFilter;
    var RENDERERS = {
      radio: MultipleSelectFilter,
      select: MultipleSelectFilter
    };

    var FilterRenderer = function FilterRenderer(_ref7) {
      var fieldName = _ref7.fieldName,
          useFieldLabel = _ref7.useFieldLabel;

      var _useContext3 = (0, _react.useContext)(_EditTableViewContext["default"]),
          _useContext4 = _slicedToArray(_useContext3, 1),
          dataDefinition = _useContext4[0].dataDefinition;

      var dataDefinitionField = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, fieldName);

      var Renderer = RENDERERS[dataDefinitionField.fieldType];

      if (!Renderer) {
        return null;
      }

      return _react["default"].createElement(Renderer, {
        dataDefinitionField: dataDefinitionField,
        useFieldLabel: useFieldLabel
      });
    };

    exports.FilterRenderer = FilterRenderer;

    var TableViewFiltersList = function TableViewFiltersList() {
      var _useContext5 = (0, _react.useContext)(_EditTableViewContext["default"]),
          _useContext6 = _slicedToArray(_useContext5, 1),
          _useContext6$ = _useContext6[0],
          fieldNames = _useContext6$.dataListView.fieldNames,
          focusedColumn = _useContext6$.focusedColumn;

      var filteredFieldNames = focusedColumn ? fieldNames.filter(function (fieldName) {
        return fieldName === focusedColumn;
      }) : fieldNames;
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('table-view-filters-list', {
          'single-field': !!focusedColumn
        })
      }, !focusedColumn && _react["default"].createElement("h4", {
        className: "table-view-filters-header"
      }, Liferay.Language.get('filter-entries-by-columns'), _react["default"].createElement("span", {
        className: "lfr-portal-tooltip tooltip-icon",
        "data-title": Liferay.Language.get('filter-entries-by-setting-filters-for-each-column')
      }, _react["default"].createElement(_icon["default"], {
        symbol: "question-circle-full"
      }))), filteredFieldNames.map(function (fieldName) {
        return _react["default"].createElement(FilterRenderer, {
          fieldName: fieldName,
          key: fieldName,
          useFieldLabel: !focusedColumn
        });
      }));
    };

    exports.TableViewFiltersList = TableViewFiltersList;
    var _default = TableViewFiltersList;
    exports["default"] = _default;
    //# sourceMappingURL=TableViewFilters.es.js.map
  }
});
//# sourceMappingURL=TableViewFilters.es.js.map