Liferay.Loader.define("app-builder-web@1.0.57/js/pages/table-view/EditTableView.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'data-engine-taglib', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/control-menu/ControlMenu.es', '../../components/drag-and-drop/DragLayer.es', '../../components/loading/Loading.es', '../../components/upper-toolbar/UpperToolbar.es', '../../utils/toast.es', '../../utils/utils.es', './DropZone.es', './EditTableViewContext.es', './EditTableViewContextProvider.es', './TableViewSidebar.es', './utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _ControlMenu = _interopRequireDefault(require("../../components/control-menu/ControlMenu.es"));

    var _DragLayer = _interopRequireDefault(require("../../components/drag-and-drop/DragLayer.es"));

    var _Loading = require("../../components/loading/Loading.es");

    var _UpperToolbar = _interopRequireDefault(require("../../components/upper-toolbar/UpperToolbar.es"));

    var _toast = require("../../utils/toast.es");

    var _utils = require("../../utils/utils.es");

    var _DropZone = _interopRequireDefault(require("./DropZone.es"));

    var _EditTableViewContext = _interopRequireWildcard(require("./EditTableViewContext.es"));

    var _EditTableViewContextProvider = _interopRequireDefault(require("./EditTableViewContextProvider.es"));

    var _TableViewSidebar = _interopRequireDefault(require("./TableViewSidebar.es"));

    var _utils2 = require("./utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var EditTableView = (0, _reactRouterDom.withRouter)(function (_ref) {
      var history = _ref.history;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          showTranslationManager = _useContext.showTranslationManager;

      var _useContext2 = (0, _react.useContext)(_EditTableViewContext["default"]),
          _useContext3 = _slicedToArray(_useContext2, 2),
          _useContext3$ = _useContext3[0],
          dataDefinition = _useContext3$.dataDefinition,
          dataListView = _useContext3$.dataListView,
          dispatch = _useContext3[1];

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          isLoading = _useState2[0],
          setLoading = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          isSidebarClosed = _useState4[0],
          setSidebarClosed = _useState4[1];

      var _useState5 = (0, _react.useState)(''),
          _useState6 = _slicedToArray(_useState5, 2),
          defaultLanguageId = _useState6[0],
          setDefaultLanguageId = _useState6[1];

      var _useState7 = (0, _react.useState)(''),
          _useState8 = _slicedToArray(_useState7, 2),
          editingLanguageId = _useState8[0],
          setEditingLanguageId = _useState8[1];

      (0, _react.useEffect)(function () {
        if (dataDefinition.defaultLanguageId) {
          setDefaultLanguageId(dataDefinition.defaultLanguageId);
          onEditingLanguageIdChange(dataDefinition.defaultLanguageId);
        }
      }, [dataDefinition.defaultLanguageId, onEditingLanguageIdChange]);
      var onEditingLanguageIdChange = (0, _react.useCallback)(function (editingLanguageId) {
        setEditingLanguageId(editingLanguageId);
        dispatch({
          payload: editingLanguageId,
          type: _EditTableViewContext.UPDATE_EDITING_LANGUAGE_ID
        });
      }, [dispatch]);

      var onError = function onError(_ref2) {
        var title = _ref2.title;
        (0, _toast.errorToast)(title);
      };

      var onSuccess = function onSuccess() {
        (0, _toast.successToast)(Liferay.Language.get('the-table-view-was-saved-successfully'));
        history.goBack();
      };

      var onSave = function onSave() {
        if (!dataListView.name[defaultLanguageId]) {
          dataListView.name[defaultLanguageId] = dataListView.name[editingLanguageId];
        }

        dataListView.name[defaultLanguageId] = (0, _utils.getValidName)(Liferay.Language.get('untitled-table-view'), dataListView.name[defaultLanguageId]);
        setLoading(true);
        (0, _utils2.saveTableView)(dataDefinition, dataListView).then(onSuccess)["catch"](function (error) {
          onError(error);
          setLoading(false);
        });
      };

      var onAddFieldName = function onAddFieldName(fieldName) {
        var index = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
        dispatch({
          payload: {
            fieldName: fieldName,
            index: index
          },
          type: _EditTableViewContext.ADD_DATA_LIST_VIEW_FIELD
        });
      };

      if (!defaultLanguageId) {
        return null;
      }

      return _react["default"].createElement("div", {
        className: "app-builder-table-view"
      }, _react["default"].createElement(_ControlMenu["default"], {
        backURL: "../",
        title: (0, _utils2.getTableViewTitle)(dataListView)
      }), _react["default"].createElement(_Loading.Loading, {
        isLoading: dataDefinition === null
      }, _react["default"].createElement(_DragLayer["default"], null), _react["default"].createElement("form", {
        onSubmit: function onSubmit(event) {
          event.preventDefault();

          if (!isLoading) {
            onSave();
          }
        }
      }, _react["default"].createElement(_UpperToolbar["default"], null, showTranslationManager && _react["default"].createElement(_UpperToolbar["default"].Group, null, _react["default"].createElement(_dataEngineTaglib.TranslationManager, {
        availableLanguageIds: dataDefinition.availableLanguageIds.reduce(function (languages, languageId) {
          return _objectSpread({}, languages, _defineProperty({}, languageId, languageId));
        }, {}),
        defaultLanguageId: defaultLanguageId,
        editingLanguageId: editingLanguageId,
        onEditingLanguageIdChange: onEditingLanguageIdChange,
        translatedLanguageIds: dataListView.name
      })), _react["default"].createElement(_UpperToolbar["default"].Input, {
        onChange: function onTableViewNameChange(_ref3) {
          var value = _ref3.target.value;
          dispatch({
            payload: {
              name: _objectSpread({}, dataListView.name, _defineProperty({}, editingLanguageId, value))
            },
            type: _EditTableViewContext.UPDATE_DATA_LIST_VIEW_NAME
          });
        },
        placeholder: Liferay.Language.get('untitled-table-view'),
        value: dataListView.name[editingLanguageId] || ''
      }), _react["default"].createElement(_UpperToolbar["default"].Group, null, _react["default"].createElement(_UpperToolbar["default"].Button, {
        displayType: "secondary",
        onClick: function onClick() {
          return history.goBack();
        }
      }, Liferay.Language.get('cancel')), _react["default"].createElement(_UpperToolbar["default"].Button, {
        disabled: isLoading || !dataListView.name[editingLanguageId],
        onClick: onSave
      }, Liferay.Language.get('save'))))), _react["default"].createElement(_TableViewSidebar["default"], {
        className: (0, _classnames["default"])('app-builder-table-view__sidebar', {
          'app-builder-table-view__sidebar--closed': isSidebarClosed
        }),
        onAddFieldName: onAddFieldName,
        onToggle: function onToggle() {
          return setSidebarClosed(!isSidebarClosed);
        }
      }), _react["default"].createElement("div", {
        className: (0, _classnames["default"])('app-builder-table-view__content', {
          'app-builder-table-view__content--sidebar-closed': isSidebarClosed
        })
      }, _react["default"].createElement("div", {
        className: "container table-view-container"
      }, _react["default"].createElement(_DropZone["default"], {
        fields: (0, _utils2.getDestructuredFields)(dataDefinition, dataListView),
        onAddFieldName: onAddFieldName,
        onRemoveFieldName: function onRemoveFieldName(fieldName) {
          dispatch({
            payload: {
              fieldName: fieldName
            },
            type: _EditTableViewContext.REMOVE_DATA_LIST_VIEW_FIELD
          });
        }
      })))));
    });

    var _default = function _default(props) {
      return _react["default"].createElement(_EditTableViewContextProvider["default"], null, _react["default"].createElement(EditTableView, props));
    };

    exports["default"] = _default;
    //# sourceMappingURL=EditTableView.es.js.map
  }
});
//# sourceMappingURL=EditTableView.es.js.map