Liferay.Loader.define("app-builder-web@1.0.57/js/pages/table-view/DropZonePlaceholder.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'data-engine-taglib', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dnd', './utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactDnd = require("frontend-js-react-web$react-dnd");

    var _utils = require("./utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var getLeft = function getLeft(container, index) {
      switch (index) {
        case 0:
          {
            return (0, _utils.getColumnNode)(container, index).offsetLeft;
          }

        case 1:
          {
            var columnNode = (0, _utils.getColumnNode)(container, index);
            var previousColumnNode = (0, _utils.getColumnNode)(container, index - 1);
            return columnNode.offsetLeft - previousColumnNode.offsetWidth / 2;
          }

        default:
          {
            return (0, _utils.getColumnNode)(container, index - 1).offsetLeft;
          }
      }
    };

    var getWidth = function getWidth(container, index, total) {
      switch (index) {
        case 0:
          {
            return (0, _utils.getColumnNode)(container, index).offsetWidth / 2;
          }

        case 1:
          {
            return (0, _utils.getColumnNode)(container, index - 1).offsetWidth / 2;
          }

        case total - 1:
          {
            return (0, _utils.getColumnNode)(container, index - 1).offsetWidth;
          }

        default:
          {
            return (0, _utils.getColumnNode)(container, index).offsetWidth;
          }
      }
    };

    var getStyle = function getStyle(container, index, total) {
      return {
        height: container.offsetHeight,
        left: getLeft(container, index),
        position: 'absolute',
        top: container.offsetTop,
        width: getWidth(container, index, total)
      };
    };

    var Placeholder = function Placeholder(_ref) {
      var container = _ref.container,
          index = _ref.index,
          onAddFieldName = _ref.onAddFieldName,
          total = _ref.total;

      var _useDrop = (0, _reactDnd.useDrop)({
        accept: _dataEngineTaglib.DragTypes.DRAG_FIELD_TYPE,
        collect: function collect(monitor) {
          return {
            canDrop: monitor.canDrop(),
            overTarget: monitor.isOver()
          };
        },
        drop: function drop(_ref2) {
          var name = _ref2.data.name;
          onAddFieldName(name, index);
        }
      }),
          _useDrop2 = _slicedToArray(_useDrop, 2),
          _useDrop2$ = _useDrop2[0],
          canDrop = _useDrop2$.canDrop,
          overTarget = _useDrop2$.overTarget,
          drop = _useDrop2[1];

      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])({
          'column-drop-zone-left': overTarget && index === 0,
          'column-drop-zone-right': overTarget && index > 0,
          hide: !canDrop,
          'target-over': overTarget
        }),
        ref: drop,
        style: getStyle(container, index, total)
      });
    };

    var _default = function _default(_ref3) {
      var container = _ref3.container,
          fields = _ref3.fields,
          onAddFieldName = _ref3.onAddFieldName;

      var _useState = (0, _react.useState)(true),
          _useState2 = _slicedToArray(_useState, 2),
          empty = _useState2[0],
          setEmpty = _useState2[1];

      (0, _react.useLayoutEffect)(function () {
        var columns = (0, _utils.getColumns)(container);
        setEmpty(columns.length === 0);
      }, [container, fields]);

      if (empty) {
        return null;
      }

      var columnPlaceholders = [];

      for (var i = 0; i < fields.length + 1; i++) {
        columnPlaceholders.push(fields[i] ? fields[i].name : 'last');
      }

      return columnPlaceholders.map(function (key, index) {
        return _react["default"].createElement(Placeholder, {
          container: container,
          index: index,
          key: key,
          onAddFieldName: onAddFieldName,
          total: columnPlaceholders.length
        });
      });
    };

    exports["default"] = _default;
    //# sourceMappingURL=DropZonePlaceholder.es.js.map
  }
});
//# sourceMappingURL=DropZonePlaceholder.es.js.map