Liferay.Loader.define("app-builder-web@1.0.57/js/pages/entry/ViewEntryUpperToolbar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/button/lib/Group', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/upper-toolbar/UpperToolbar.es', '../../hooks/usePermissions.es', '../../utils/client.es', '../../utils/lang.es', './utils.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _Group = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button/lib/Group"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../../AppContext.es");

    var _UpperToolbar = _interopRequireDefault(require("../../components/upper-toolbar/UpperToolbar.es"));

    var _usePermissions = _interopRequireDefault(require("../../hooks/usePermissions.es"));

    var _client = require("../../utils/client.es");

    var _lang = require("../../utils/lang.es");

    var _utils = require("./utils.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function ViewEntryUpperToolbar(_ref) {
      var _showButtons$delete, _showButtons$update;

      var additionalButtons = _ref.additionalButtons,
          children = _ref.children,
          dataRecordId = _ref.dataRecordId,
          history = _ref.history,
          page = _ref.page,
          showButtons = _ref.showButtons,
          totalCount = _ref.totalCount;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          appDeploymentType = _useContext.appDeploymentType,
          basePortletURL = _useContext.basePortletURL,
          showFormView = _useContext.showFormView,
          userLanguageId = _useContext.userLanguageId;

      var permissions = (0, _usePermissions["default"])();

      var changeEntryIndex = function changeEntryIndex(entryIndex) {
        history.push("/entries/".concat(entryIndex, "?").concat(window.location.search));
      };

      var showDeleteButton = (_showButtons$delete = showButtons === null || showButtons === void 0 ? void 0 : showButtons["delete"]) !== null && _showButtons$delete !== void 0 ? _showButtons$delete : true;
      var showUpdateButton = (_showButtons$update = showButtons === null || showButtons === void 0 ? void 0 : showButtons.update) !== null && _showButtons$update !== void 0 ? _showButtons$update : true;
      return _react["default"].createElement(_UpperToolbar["default"], {
        className: appDeploymentType
      }, _react["default"].createElement(_UpperToolbar["default"].Item, {
        className: "ml-2 text-left"
      }, _react["default"].createElement("label", null, totalCount > 0 && (0, _lang.sub)(totalCount == 1 ? Liferay.Language.get('x-of-x-entry') : Liferay.Language.get('x-of-x-entries'), [page, totalCount]))), _react["default"].createElement(_UpperToolbar["default"].Item, {
        expand: true
      }, children), _react["default"].createElement(_UpperToolbar["default"].Group, null, _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_Group["default"], null, _react["default"].createElement(_button.ClayButtonWithIcon, {
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        disabled: page === 1,
        displayType: "secondary",
        onClick: function onPrev() {
          var prevIndex = Math.max(parseInt(page, 10) - 1, 1);
          changeEntryIndex(prevIndex);
        },
        small: true,
        symbol: "angle-left",
        title: Liferay.Language.get('previous-entry')
      }), _react["default"].createElement(_button.ClayButtonWithIcon, {
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        disabled: page === totalCount,
        displayType: "secondary",
        onClick: function onNext() {
          var nextIndex = Math.min(parseInt(page, 10) + 1, totalCount);
          changeEntryIndex(nextIndex);
        },
        small: true,
        symbol: "angle-right",
        title: Liferay.Language.get('next-entry')
      })))), showFormView && _react["default"].createElement(_UpperToolbar["default"].Group, null, permissions["delete"] && showDeleteButton && _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_button.ClayButtonWithIcon, {
        className: "mr-2",
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        displayType: "secondary",
        onClick: function onDelete() {
          (0, _client.confirmDelete)('/o/data-engine/v2.0/data-records/', {
            successMessage: Liferay.Language.get('an-entry-was-deleted')
          })({
            id: dataRecordId
          }).then(function (confirmed) {
            if (confirmed) {
              history.push('/');
            }
          });
        },
        small: true,
        symbol: "trash",
        title: Liferay.Language.get('delete')
      })), permissions.update && showUpdateButton && _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_button.ClayButtonWithIcon, {
        className: "mr-2",
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        displayType: "secondary",
        onClick: function onEdit() {
          (0, _utils.navigateToEditPage)(basePortletURL, {
            dataRecordId: dataRecordId,
            languageId: userLanguageId,
            redirect: location.href
          });
        },
        small: true,
        symbol: "pencil",
        title: Liferay.Language.get('edit')
      })), additionalButtons));
    }

    var _default = (0, _reactRouterDom.withRouter)(ViewEntryUpperToolbar);

    exports["default"] = _default;
    //# sourceMappingURL=ViewEntryUpperToolbar.es.js.map
  }
});
//# sourceMappingURL=ViewEntryUpperToolbar.es.js.map