Liferay.Loader.define("app-builder-web@1.0.57/js/pages/entry/FieldPreview.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/panel', '@frontend-taglib-clay$clayui/tooltip', 'data-engine-taglib', 'frontend-js-react-web$react', '../../AppContext.es', '../../utils/lang.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.FieldValuePreview = exports.SectionRenderer = void 0;

    var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = require("@frontend-taglib-clay$clayui/layout");

    var _panel = _interopRequireDefault(require("@frontend-taglib-clay$clayui/panel"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _dataEngineTaglib = require("data-engine-taglib");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext.es");

    var _lang = require("../../utils/lang.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var createFileEntryPreviewURL = function createFileEntryPreviewURL(groupId, fileEntryId) {
      var portletURL = Liferay.PortletURL.createURL(themeDisplay.getLayoutRelativeControlPanelURL());
      portletURL.setParameter('doAsGroupId', groupId);
      portletURL.setParameter('fileEntryId', fileEntryId);
      portletURL.setParameter('mvcRenderCommandName', '/document_library/view_file_entry');
      portletURL.setParameter('p_p_auth', Liferay.authToken);
      portletURL.setParameter('refererGroupId', themeDisplay.getScopeGroupId());
      portletURL.setPortletId(Liferay.PortletKeys.DOCUMENT_LIBRARY);
      portletURL.setPortletMode('view');
      portletURL.setWindowState('pop_up');
      return portletURL.toString();
    };

    var getDocumentIcon = function getDocumentIcon(fileName) {
      var extension = fileName.split('.').pop();

      if (extension === 'pdf') {
        return 'document-pdf';
      }

      if (extension === 'doc' || extension === 'txt') {
        return 'document-text';
      }

      return 'document-default';
    };

    var DocumentRenderer = function DocumentRenderer(_ref) {
      var displayType = _ref.displayType,
          _ref$value = _ref.value,
          value = _ref$value === void 0 ? {} : _ref$value;
      var fileEntry = {};

      if (typeof value === 'string' && value.startsWith('{')) {
        fileEntry = JSON.parse(value);
      }

      var _fileEntry = fileEntry,
          fileEntryId = _fileEntry.fileEntryId,
          folderId = _fileEntry.folderId,
          groupId = _fileEntry.groupId,
          _fileEntry$title = _fileEntry.title,
          title = _fileEntry$title === void 0 ? '' : _fileEntry$title;

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          previewURL = _useState2[0],
          setPreviewURL = _useState2[1];

      (0, _react.useEffect)(function () {
        AUI().use('liferay-portlet-url', function () {
          setPreviewURL(createFileEntryPreviewURL(groupId, fileEntryId));
        });
      });

      return _react["default"].createElement(_react["default"].Fragment, null, displayType === 'list' ? _react["default"].createElement(StringRenderer, {
        value: title
      }) : fileEntryId ? _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_button["default"].Group, {
        className: "data-record-document-field"
      }, _react["default"].createElement(_button["default"], {
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        displayType: "secondary",
        onClick: function onClickPreview() {
          Liferay.Util.openWindow({
            dialog: {
              destroyOnHide: true,
              modal: true
            },
            title: Liferay.Language.get('file-preview'),
            uri: previewURL
          });
        },
        title: Liferay.Language.get('file-preview')
      }, _react["default"].createElement(_icon["default"], {
        className: "mr-2",
        symbol: getDocumentIcon(title)
      }), title), _react["default"].createElement(_button.ClayButtonWithIcon, {
        "data-tooltip-align": "bottom",
        "data-tooltip-delay": "200",
        displayType: "secondary",
        onClick: function onClickDownload() {
          location.href = "".concat(themeDisplay.getPathContext(), "/documents/").concat(groupId, "/").concat(folderId || '0', "/").concat(encodeURIComponent(title), "?download=true");
        },
        symbol: "download",
        title: Liferay.Language.get('download')
      }))) : _react["default"].createElement(StringRenderer, null));
    };

    var getRepeatableOptionValues = function getRepeatableOptionValues() {
      var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

      if (Array.isArray(value)) {
        return value;
      }

      return value.substring(1, value.length - 1).split(',').map(function (v) {
        return v.trim();
      });
    };

    var OptionsRenderer = function OptionsRenderer(_ref2) {
      var dataDefinitionField = _ref2.dataDefinitionField,
          displayType = _ref2.displayType,
          getOptionValue = _ref2.getOptionValue,
          _ref2$values = _ref2.values,
          values = _ref2$values === void 0 ? [] : _ref2$values;
      var repeatable = dataDefinitionField.repeatable;
      var labels = values.map(function (value) {
        if (repeatable) {
          var newValue = value;
          newValue = getRepeatableOptionValues(newValue).map(getOptionValue).join(', ');
          return newValue;
        }

        return getOptionValue(value);
      });

      if (displayType === 'list' || labels.length === 0) {
        return _react["default"].createElement(StringRenderer, {
          value: labels.join(', ')
        });
      }

      return _react["default"].createElement("ul", null, labels.map(function (label, index) {
        return _react["default"].createElement("li", {
          key: index
        }, label);
      }));
    };

    var StringRenderer = function StringRenderer(_ref3) {
      var value = _ref3.value;
      return _react["default"].createElement("span", {
        className: "d-block"
      }, (Array.isArray(value) ? value.join(', ') : value) || ' - ');
    };

    var SectionRenderer = function SectionRenderer(_ref4) {
      var children = _ref4.children,
          collapsible = _ref4.collapsible,
          dataDefinition = _ref4.dataDefinition,
          fieldName = _ref4.fieldName;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          userLanguageId = _useContext.userLanguageId;

      var _DataDefinitionUtils$ = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, fieldName),
          label = _DataDefinitionUtils$.label;

      var localizedLabel = (0, _lang.getLocalizedUserPreferenceValue)(label, userLanguageId, dataDefinition.defaultLanguageId);
      return _react["default"].createElement(_panel["default"], {
        className: "data-record-section",
        collapsable: collapsible,
        defaultExpanded: true,
        displayTitle: _react["default"].createElement(_layout.SheetSection, null, _react["default"].createElement("div", {
          className: "autofit-row sheet-subtitle"
        }, _react["default"].createElement("span", {
          className: "autofit-col autofit-col-expand"
        }, _react["default"].createElement("label", {
          className: "text-uppercase"
        }, localizedLabel)))),
        showCollapseIcon: true
      }, _react["default"].createElement(_panel["default"].Body, null, children));
    };

    exports.SectionRenderer = SectionRenderer;

    var getFieldValueRenderer = function getFieldValueRenderer(dataDefinitionField, displayType, userLanguageId) {
      var customProperties = dataDefinitionField.customProperties,
          defaultLanguageId = dataDefinitionField.defaultLanguageId,
          fieldType = dataDefinitionField.fieldType,
          repeatable = dataDefinitionField.repeatable;
      var multiple = customProperties.multiple,
          options = customProperties.options;

      var getOptionValue = function getOptionValue(value) {
        return _dataEngineTaglib.DataDefinitionUtils.getOptionLabel(options, value, defaultLanguageId, userLanguageId);
      };

      var OptionsRendererWrapper = function OptionsRendererWrapper(_ref5) {
        var value = _ref5.value;
        return _react["default"].createElement(OptionsRenderer, {
          dataDefinitionField: dataDefinitionField,
          displayType: displayType,
          getOptionValue: getOptionValue,
          values: value
        });
      };

      if (fieldType === 'checkbox_multiple') {
        return OptionsRendererWrapper;
      }

      if (fieldType === 'document_library') {
        return function (_ref6) {
          var value = _ref6.value;
          return _react["default"].createElement(DocumentRenderer, {
            displayType: displayType,
            value: value
          });
        };
      }

      if (fieldType === 'radio') {
        return function (_ref7) {
          var value = _ref7.value;
          var newValue = getOptionValue(value);

          if (repeatable) {
            newValue = getRepeatableOptionValues(value).map(getOptionValue);
          }

          return _react["default"].createElement(StringRenderer, {
            value: newValue
          });
        };
      }

      if (fieldType === 'select') {
        if (multiple) {
          return OptionsRendererWrapper;
        }

        return function (_ref8) {
          var _ref8$value = _ref8.value,
              value = _ref8$value === void 0 ? [] : _ref8$value;
          var newValue = getOptionValue(value[0]);

          if (repeatable) {
            newValue = value.map(getRepeatableOptionValues).map(function (value) {
              return getOptionValue(value[0]);
            });
          }

          return _react["default"].createElement(StringRenderer, {
            value: newValue
          });
        };
      }

      return function (_ref9) {
        var value = _ref9.value;
        return _react["default"].createElement(StringRenderer, {
          value: value
        });
      };
    };

    var FieldValuePreview = function FieldValuePreview(_ref10) {
      var dataDefinition = _ref10.dataDefinition,
          dataRecordValues = _ref10.dataRecordValues,
          _ref10$displayType = _ref10.displayType,
          displayType = _ref10$displayType === void 0 ? 'form' : _ref10$displayType,
          fieldName = _ref10.fieldName;

      var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
          userLanguageId = _useContext2.userLanguageId;

      var defaultLanguageId = dataDefinition.defaultLanguageId;

      var dataDefinitionField = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, fieldName);

      var Renderer = getFieldValueRenderer(dataDefinitionField, displayType, userLanguageId);
      var value = dataRecordValues[fieldName];

      if (dataDefinitionField.localizable) {
        return _react["default"].createElement(Renderer, {
          value: value ? value[defaultLanguageId] : undefined
        });
      }

      return _react["default"].createElement(Renderer, {
        value: value
      });
    };

    exports.FieldValuePreview = FieldValuePreview;

    var _default = function _default(_ref11) {
      var dataDefinition = _ref11.dataDefinition,
          dataRecordValues = _ref11.dataRecordValues,
          defaultLanguageId = _ref11.defaultLanguageId,
          fieldName = _ref11.fieldName;

      var _useContext3 = (0, _react.useContext)(_AppContext.AppContext),
          userLanguageId = _useContext3.userLanguageId;

      var _DataDefinitionUtils$2 = _dataEngineTaglib.DataDefinitionUtils.getDataDefinitionField(dataDefinition, fieldName),
          label = _DataDefinitionUtils$2.label;

      var localizedLabel = (0, _lang.getLocalizedUserPreferenceValue)(label, userLanguageId, defaultLanguageId);
      return _react["default"].createElement("div", {
        className: "data-record-field-preview"
      }, _react["default"].createElement("label", null, localizedLabel), _react["default"].createElement(FieldValuePreview, {
        dataDefinition: dataDefinition,
        dataRecordValues: dataRecordValues,
        fieldName: fieldName
      }));
    };

    exports["default"] = _default;
    //# sourceMappingURL=FieldPreview.es.js.map
  }
});
//# sourceMappingURL=FieldPreview.es.js.map