Liferay.Loader.define("app-builder-web@1.0.57/js/pages/entry/EditEntry.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$react', '../../AppContext.es', '../../components/button/Button.es', '../../components/control-menu/ControlMenu.es', '../../hooks/useDataDefinition.es', '../../hooks/withDDMForm.es', '../../utils/client.es', '../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.EditEntry = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext.es");

    var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

    var _ControlMenu = require("../../components/control-menu/ControlMenu.es");

    var _useDataDefinition2 = _interopRequireDefault(require("../../hooks/useDataDefinition.es"));

    var _withDDMForm = _interopRequireWildcard(require("../../hooks/withDDMForm.es"));

    var _client = require("../../utils/client.es");

    var _toast = require("../../utils/toast.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var EditEntry = function EditEntry(_ref) {
      var dataDefinitionId = _ref.dataDefinitionId,
          dataRecordId = _ref.dataRecordId,
          ddmForm = _ref.ddmForm,
          redirect = _ref.redirect,
          userLanguageId = _ref.userLanguageId;

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          basePortletURL = _useContext.basePortletURL;

      var _useDataDefinition = (0, _useDataDefinition2["default"])(dataDefinitionId),
          availableLanguageIds = _useDataDefinition.availableLanguageIds,
          defaultLanguageId = _useDataDefinition.defaultLanguageId;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          submitting = _useState2[0],
          setSubmitting = _useState2[1];

      var onCancel = (0, _react.useCallback)(function () {
        if (redirect) {
          Liferay.Util.navigate(redirect);
        } else {
          Liferay.Util.navigate(basePortletURL);
        }
      }, [basePortletURL, redirect]);

      var onError = function onError() {
        (0, _toast.errorToast)();
        setSubmitting(false);
      };

      var validateForm = (0, _withDDMForm.useDDMFormValidation)(ddmForm, defaultLanguageId, availableLanguageIds);
      var onSubmit = (0, _react.useCallback)(function (event) {
        setSubmitting(true);
        validateForm(event).then(function (dataRecord) {
          if (dataRecordId !== '0') {
            (0, _client.updateItem)({
              endpoint: "/o/data-engine/v2.0/data-records/".concat(dataRecordId),
              item: dataRecord,
              method: 'PATCH'
            }).then(function () {
              (0, _toast.successToast)(Liferay.Language.get('an-entry-was-updated'));
              onCancel();
            })["catch"](onError);
          } else {
            (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-records"), dataRecord).then(function () {
              (0, _toast.successToast)(Liferay.Language.get('an-entry-was-added'));
              onCancel();
            })["catch"](onError);
          }
        })["catch"](function () {
          setSubmitting(false);
        });
      }, [dataDefinitionId, dataRecordId, onCancel, validateForm]);
      (0, _withDDMForm.useDDMFormSubmit)(ddmForm, onSubmit);
      (0, _react.useEffect)(function () {
        var ddmReactForm = ddmForm.reactComponentRef.current;
        ddmReactForm.updateEditingLanguageId({
          editingLanguageId: userLanguageId,
          preserveValue: true
        });
      }, [ddmForm, userLanguageId]);
      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_ControlMenu.ControlMenuBase, {
        backURL: redirect ? redirect : "".concat(basePortletURL, "/#/"),
        title: dataRecordId !== '0' ? Liferay.Language.get('edit-entry') : Liferay.Language.get('add-entry'),
        url: location.href
      }), _react["default"].createElement(_button["default"].Group, {
        className: "app-builder-form-buttons",
        spaced: true
      }, _react["default"].createElement(_Button["default"], {
        disabled: submitting,
        onClick: onSubmit
      }, Liferay.Language.get('save')), _react["default"].createElement(_Button["default"], {
        displayType: "secondary",
        onClick: onCancel
      }, Liferay.Language.get('cancel'))));
    };

    exports.EditEntry = EditEntry;

    var _default = (0, _withDDMForm["default"])(EditEntry);

    exports["default"] = _default;
    //# sourceMappingURL=EditEntry.es.js.map
  }
});
//# sourceMappingURL=EditEntry.es.js.map