Liferay.Loader.define("app-builder-web@1.0.57/js/pages/apps/DropDownWithSearch.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/drop-down', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.DropDownContext = void 0;

    var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var DropDownContext = (0, _react.createContext)();
    exports.DropDownContext = DropDownContext;

    var DropDownWithSearch = function DropDownWithSearch(_ref) {
      var children = _ref.children,
          error = _ref.error,
          isEmpty = _ref.isEmpty,
          isLoading = _ref.isLoading,
          _ref$stateProps = _ref.stateProps,
          emptyProps = _ref$stateProps.emptyProps,
          errorProps = _ref$stateProps.errorProps,
          loadingProps = _ref$stateProps.loadingProps,
          trigger = _ref.trigger,
          _ref$visible = _ref.visible,
          visible = _ref$visible === void 0 ? true : _ref$visible,
          restProps = _objectWithoutProperties(_ref, ["children", "error", "isEmpty", "isLoading", "stateProps", "trigger", "visible"]);

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _useState3 = (0, _react.useState)(),
          _useState4 = _slicedToArray(_useState3, 2),
          dropDownWidth = _useState4[0],
          setDropDownWidth = _useState4[1];

      var _useState5 = (0, _react.useState)(''),
          _useState6 = _slicedToArray(_useState5, 2),
          query = _useState6[0],
          setQuery = _useState6[1];

      var _useState7 = (0, _react.useState)(trigger),
          _useState8 = _slicedToArray(_useState7, 2),
          triggerElement = _useState8[0],
          setTriggerElement = _useState8[1];

      (0, _react.useEffect)(function () {
        setTriggerElement((0, _react.cloneElement)(trigger, {
          ref: function ref(element) {
            if (element) {
              setDropDownWidth("".concat(element.offsetWidth, "px"));

              if (typeof trigger.ref === 'function') {
                trigger.ref(element);
              }
            }

            return trigger.ref;
          }
        })); // eslint-disable-next-line react-hooks/exhaustive-deps
      }, [trigger]);
      return _react["default"].createElement(DropDownContext.Provider, {
        value: {
          query: query,
          setActive: setActive,
          setQuery: setQuery
        }
      }, _react["default"].createElement(_dropDown["default"], _extends({}, restProps, {
        active: active && visible,
        alignmentPosition: _dropDown.Align.BottomLeft,
        menuElementAttrs: {
          className: 'select-dropdown-menu',
          onClick: function onClick(event) {
            event.stopPropagation();
          },
          style: {
            maxWidth: dropDownWidth,
            width: '100%'
          }
        },
        onActiveChange: function onActiveChange(newActive) {
          setActive(newActive);
          setQuery('');
        },
        trigger: triggerElement
      }), _react["default"].createElement(Search, {
        disabled: isEmpty
      }), isLoading && _react["default"].createElement(LoadingState, loadingProps), error && _react["default"].createElement(EmptyState, _extends({
        className: "error-state-dropdown-menu"
      }, errorProps)), !isLoading && !error && isEmpty && _react["default"].createElement(EmptyState, _extends({
        className: "empty-state-dropdown-menu"
      }, emptyProps)), children));
    };

    var EmptyState = function EmptyState(_ref2) {
      var children = _ref2.children,
          className = _ref2.className,
          label = _ref2.label;
      return _react["default"].createElement("div", {
        className: className
      }, _react["default"].createElement("label", {
        className: "font-weight-light text-muted"
      }, label), children);
    };

    var Items = function Items(_ref3) {
      var children = _ref3.children,
          emptyResultMessage = _ref3.emptyResultMessage,
          _ref3$items = _ref3.items,
          items = _ref3$items === void 0 ? [] : _ref3$items,
          _ref3$propertyKey = _ref3.propertyKey,
          propertyKey = _ref3$propertyKey === void 0 ? 'name' : _ref3$propertyKey,
          onSelect = _ref3.onSelect;

      var _useContext = (0, _react.useContext)(DropDownContext),
          query = _useContext.query,
          setActive = _useContext.setActive,
          setQuery = _useContext.setQuery;

      var treatedQuery = query.toLowerCase().replace(/[.*+\-?^${}()|[\]\\]/g, '\\$&');
      var itemList = items.filter(function (_ref4) {
        var name = _ref4[propertyKey];
        return name.toLowerCase().match(treatedQuery);
      });

      var _onClick = function onClick(event, selectedValue) {
        event.stopPropagation();
        setQuery('');
        setActive(false);
        onSelect(selectedValue);
      };

      return _react["default"].createElement(_dropDown["default"].ItemList, null, itemList.length > 0 ? itemList.map(function (item, index) {
        return _react["default"].createElement(_dropDown["default"].Item, {
          disabled: item.disabled,
          key: index,
          onClick: function onClick(event) {
            return _onClick(event, item);
          }
        }, children ? children(item) : item.name);
      }) : items.length > 0 && _react["default"].createElement("p", {
        className: "font-weight-light m-0 px-3 py-2 text-muted"
      }, emptyResultMessage));
    };

    var LoadingState = function LoadingState(_ref5) {
      var label = _ref5.label;
      return _react["default"].createElement("div", {
        className: "loading-state-dropdown-menu"
      }, _react["default"].createElement("span", {
        "aria-hidden": "true",
        className: "loading-animation"
      }), _react["default"].createElement("label", {
        className: "font-weight-light text-secondary"
      }, label));
    };

    var Search = function Search(_ref6) {
      var disabled = _ref6.disabled;

      var _useContext2 = (0, _react.useContext)(DropDownContext),
          query = _useContext2.query,
          setQuery = _useContext2.setQuery;

      return _react["default"].createElement(_dropDown["default"].Search, {
        disabled: disabled,
        formProps: {
          onSubmit: function onSubmit(e) {
            return e.preventDefault();
          }
        },
        onChange: function onChange(event) {
          return setQuery(event.target.value);
        },
        placeholder: Liferay.Language.get('search'),
        value: query
      });
    };

    DropDownWithSearch.Items = Items;
    var _default = DropDownWithSearch;
    exports["default"] = _default;
    //# sourceMappingURL=DropDownWithSearch.es.js.map
  }
});
//# sourceMappingURL=DropDownWithSearch.es.js.map