Liferay.Loader.define("app-builder-web@1.0.57/js/hooks/useQuery.es", ['module', 'exports', 'require', 'app-builder-web$qs'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = exports.toQueryString = exports.toQuery = void 0;

    var _qs = _interopRequireDefault(require("app-builder-web$qs"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var qsOptions = {
      allowDots: true,
      arrayFormat: 'bracket'
    };

    var toQuery = function toQuery() {
      var queryString = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
      var defaultQuery = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var scope = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var query = queryString.length ? _qs["default"].parse(queryString.substr(1), qsOptions) : {};
      var currentQuery = scope ? query[scope] : query;
      return _objectSpread({}, defaultQuery, {}, currentQuery);
    };

    exports.toQuery = toQuery;

    var toQueryString = function toQueryString(query) {
      return query ? "".concat(_qs["default"].stringify(query, qsOptions)) : '';
    };

    exports.toQueryString = toQueryString;

    var _default = function _default(history) {
      var defaultQuery = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var scope = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var location = history.location;
      var pathname = location.pathname,
          search = location.search;
      var currentQuery = toQuery(search, defaultQuery, scope);
      return [currentQuery, function (query) {
        var scopedQuery = scope ? _defineProperty({}, scope, query) : query;
        history.push("".concat(pathname, "?").concat(toQueryString(_objectSpread({}, toQuery(search), {}, scopedQuery))));
      }];
    };

    exports["default"] = _default;
    //# sourceMappingURL=useQuery.es.js.map
  }
});
//# sourceMappingURL=useQuery.es.js.map