Liferay.Loader.define("app-builder-web@1.0.57/js/hooks/useEntriesActions.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../AppContext.es', '../pages/entry/utils.es', '../utils/client.es', './usePermissions.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = useEntriesActions;

    var _react = require("frontend-js-react-web$react");

    var _reactRouterDom = require("app-builder-web$react-router-dom");

    var _AppContext = require("../AppContext.es");

    var _utils = require("../pages/entry/utils.es");

    var _client = require("../utils/client.es");

    var _usePermissions = _interopRequireDefault(require("./usePermissions.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function useEntriesActions(showOptions) {
      var actions = [];

      var _useContext = (0, _react.useContext)(_AppContext.AppContext),
          basePortletURL = _useContext.basePortletURL,
          showFormView = _useContext.showFormView,
          userLanguageId = _useContext.userLanguageId;

      var _useContext2 = (0, _react.useContext)(_reactRouterDom.__RouterContext),
          history = _useContext2.history;

      var permissions = (0, _usePermissions["default"])();

      if (showFormView) {
        if (permissions.view) {
          actions.push({
            action: function action(_ref) {
              var viewURL = _ref.viewURL;
              return Promise.resolve(history.push(viewURL));
            },
            name: Liferay.Language.get('view'),
            show: showOptions === null || showOptions === void 0 ? void 0 : showOptions.view
          });
        }

        if (permissions.update) {
          actions.push({
            action: function action(_ref2) {
              var id = _ref2.id;
              return Promise.resolve((0, _utils.navigateToEditPage)(basePortletURL, {
                dataRecordId: id,
                languageId: userLanguageId
              }));
            },
            name: Liferay.Language.get('edit'),
            show: showOptions === null || showOptions === void 0 ? void 0 : showOptions.update
          });
        }

        if (permissions["delete"]) {
          actions.push({
            action: (0, _client.confirmDelete)('/o/data-engine/v2.0/data-records/', {
              successMessage: Liferay.Language.get('an-entry-was-deleted')
            }),
            name: Liferay.Language.get('delete'),
            show: showOptions === null || showOptions === void 0 ? void 0 : showOptions["delete"]
          });
        }
      }

      return actions;
    }
    //# sourceMappingURL=useEntriesActions.es.js.map
  }
});
//# sourceMappingURL=useEntriesActions.es.js.map