Liferay.Loader.define("app-builder-web@1.0.57/js/components/management-toolbar/ManagementToolbarFilterAndOrder.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/management-toolbar', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../../pages/apps/constants.es', '../button/Button.es', '../management-toolbar/SearchContext.es', './DropDown.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _managementToolbar = _interopRequireDefault(require("@frontend-taglib-clay$clayui/management-toolbar"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _constants = require("../../pages/apps/constants.es");

    var _Button = _interopRequireDefault(require("../button/Button.es"));

    var _SearchContext = _interopRequireDefault(require("../management-toolbar/SearchContext.es"));

    var _DropDown = _interopRequireWildcard(require("./DropDown.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var getSortable = function getSortable(columns) {
      var sort = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      if (sort.length) {
        var _sort$split = sort.split(':'),
            _sort$split2 = _slicedToArray(_sort$split, 2),
            column = _sort$split2[0],
            order = _sort$split2[1];

        return {
          asc: order === 'asc',
          column: column
        };
      } else if (columns.length) {
        var _ref = columns.find(function (_ref2) {
          var asc = _ref2.asc;
          return asc !== undefined;
        }) || columns[0],
            _ref$asc = _ref.asc,
            asc = _ref$asc === void 0 ? true : _ref$asc,
            _column = _ref.key;

        return {
          asc: asc,
          column: _column
        };
      }

      return {};
    };

    var _default = function _default(_ref3) {
      var _ref3$columns = _ref3.columns,
          columns = _ref3$columns === void 0 ? [] : _ref3$columns,
          disabled = _ref3.disabled,
          _ref3$filters = _ref3.filters,
          filters = _ref3$filters === void 0 ? [] : _ref3$filters;

      var _useContext = (0, _react.useContext)(_SearchContext["default"]),
          _useContext2 = _slicedToArray(_useContext, 2),
          _useContext2$ = _useContext2[0],
          _useContext2$$filters = _useContext2$.filters,
          appliedFilters = _useContext2$$filters === void 0 ? {} : _useContext2$$filters,
          sort = _useContext2$.sort,
          dispatch = _useContext2[1];

      var _useState = (0, _react.useState)(appliedFilters),
          _useState2 = _slicedToArray(_useState, 2),
          localFilters = _useState2[0],
          setLocalFilters = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          isDropDownActive = _useState4[0],
          setDropDownActive = _useState4[1];

      var sortableColumns = columns.filter(function (_ref4) {
        var sortable = _ref4.sortable;
        return sortable;
      });

      var _getSortable = getSortable(sortableColumns, sort),
          asc = _getSortable.asc,
          column = _getSortable.column;

      var _useState5 = (0, _react.useState)(column),
          _useState6 = _slicedToArray(_useState5, 2),
          sortColumn = _useState6[0],
          setSortColumn = _useState6[1];

      var filterItems = filters.map(function (_ref5) {
        var items = _ref5.items,
            key = _ref5.key,
            multiple = _ref5.multiple,
            name = _ref5.name;
        var props = {
          checked: localFilters[key],
          items: items,
          label: _constants.FILTER_NAMES[name][1]
        };

        if (multiple) {
          return _react["default"].createElement(_DropDown.CheckboxGroup, _extends({}, props, {
            onAdd: function onAdd(value) {
              setLocalFilters(function (prevFilters) {
                var values = prevFilters[key] || [];
                return _objectSpread({}, prevFilters, _defineProperty({}, key, values.concat(value)));
              });
            },
            onRemove: function onRemove(value) {
              setLocalFilters(function (prevFilters) {
                return _objectSpread({}, prevFilters, _defineProperty({}, key, prevFilters[key].filter(function (currentValue) {
                  return currentValue !== value;
                })));
              });
            }
          }));
        } else {
          return _react["default"].createElement(_DropDown.RadioGroup, _extends({}, props, {
            items: [{
              label: Liferay.Language.get('any')
            }].concat(_toConsumableArray(props.items)),
            onChange: function onChange(value) {
              setLocalFilters(function (prevFilters) {
                return _objectSpread({}, prevFilters, _defineProperty({}, key, value));
              });
            }
          }));
        }
      });
      var enableDoneButton = filterItems.length > 0;

      var orderByItems = function orderByItems() {
        if (sortableColumns.length === 0) {
          return [];
        }

        var props = {
          checked: sortColumn,
          items: sortableColumns.map(function (_ref6) {
            var key = _ref6.key,
                value = _ref6.value;
            return {
              label: value,
              value: key
            };
          }),
          label: Liferay.Language.get('order-by')
        };

        var item = _react["default"].createElement(_DropDown.RadioGroup, _extends({}, props, {
          onChange: setSortColumn
        }));

        if (!enableDoneButton) {
          item = _react["default"].createElement(_DropDown.ItemsGroup, _extends({}, props, {
            onClick: function onClick(newColumn) {
              setSortColumn(newColumn);
              onSortButtonClick(asc, newColumn);
              setDropDownActive(false);
            }
          }));
        }

        return [item];
      };

      var dropDownItems = [].concat(_toConsumableArray(filterItems), _toConsumableArray(orderByItems()));

      var onSortButtonClick = function onSortButtonClick(asc, newColumn) {
        dispatch({
          sort: "".concat(newColumn, ":").concat(asc ? 'asc' : 'desc'),
          type: 'SORT'
        });
      };

      return _react["default"].createElement(_react["default"].Fragment, null, dropDownItems.length > 0 && _react["default"].createElement(_managementToolbar["default"].ItemList, null, _react["default"].createElement(_managementToolbar["default"].Item, null, _react["default"].createElement(_DropDown["default"], {
        active: isDropDownActive,
        footerContent: enableDoneButton && _react["default"].createElement(_button["default"], {
          block: true,
          onClick: function onDoneButtonClick() {
            dispatch({
              filters: localFilters,
              sort: "".concat(sortColumn, ":").concat(asc ? 'asc' : 'desc'),
              type: 'UPDATE_FILTERS_AND_SORT'
            });
            setDropDownActive(false);
          }
        }, Liferay.Language.get('done')),
        onActiveChange: function onDropDownActiveChange(active) {
          setDropDownActive(active);
          setLocalFilters(appliedFilters);
          setSortColumn(column);
        },
        trigger: _react["default"].createElement(_button["default"], {
          className: "nav-link",
          disabled: disabled,
          displayType: "unstyled",
          id: "filter-and-order"
        }, _react["default"].createElement("span", {
          className: "navbar-breakpoint-down-d-none"
        }, Liferay.Language.get('filter-and-order'), _react["default"].createElement(_icon["default"], {
          className: "inline-item inline-item-after",
          symbol: "caret-bottom"
        })), _react["default"].createElement("span", {
          className: "navbar-breakpoint-d-none"
        }, _react["default"].createElement(_icon["default"], {
          className: "inline-item inline-item-after",
          symbol: "filter"
        })))
      }, dropDownItems.map(function (item, index) {
        return _react["default"].createElement("div", {
          key: index
        }, item);
      }))), _react["default"].createElement(_managementToolbar["default"].Item, null, _react["default"].createElement(_Button["default"], {
        className: (0, _classnames["default"])('nav-link', 'nav-link-monospaced', {
          'order-arrow-down-active': !asc,
          'order-arrow-up-active': asc
        }),
        disabled: disabled,
        displayType: "unstyled",
        onClick: function onClick() {
          return onSortButtonClick(!asc, column);
        },
        symbol: "order-arrow",
        tooltip: Liferay.Language.get('reverse-sort-direction')
      }))));
    };

    exports["default"] = _default;
    //# sourceMappingURL=ManagementToolbarFilterAndOrder.es.js.map
  }
});
//# sourceMappingURL=ManagementToolbarFilterAndOrder.es.js.map