Liferay.Loader.define('app-builder-web$lodash-es@4.17.15/_memoizeCapped', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import memoize from './memoize.js';

  /** Used as the maximum memoize cache size. */
  var MAX_MEMOIZE_SIZE = 500;

  /**
   * A specialized version of `_.memoize` which clears the memoized function's
   * cache when it exceeds `MAX_MEMOIZE_SIZE`.
   *
   * @private
   * @param {Function} func The function to have its output memoized.
   * @returns {Function} Returns the new memoized function.
   */
  function memoizeCapped(func) {
    var result = memoize(func, function (key) {
      if (cache.size === MAX_MEMOIZE_SIZE) {
        cache.clear();
      }
      return key;
    });

    var cache = result.cache;
    return result;
  }

  export default memoizeCapped;
});
//# sourceMappingURL=_memoizeCapped.js.map