Liferay.Loader.define("app-builder-web@1.0.31/js/pages/table-view/ListTableViews.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../utils/client.es', '../../utils/time.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

  var _client = require("../../utils/client.es");

  var _time = require("../../utils/time.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var COLUMNS = [{
    key: 'name',
    sortable: true,
    value: Liferay.Language.get('name')
  }, {
    key: 'dateCreated',
    sortable: true,
    value: Liferay.Language.get('create-date')
  }, {
    asc: false,
    key: 'dateModified',
    sortable: true,
    value: Liferay.Language.get('modified-date')
  }];

  var _default = function _default(_ref) {
    var history = _ref.history,
        _ref$match = _ref.match,
        dataDefinitionId = _ref$match.params.dataDefinitionId,
        url = _ref$match.url;
    return _react["default"].createElement(_ListView["default"], {
      actions: [{
        action: function action(item) {
          return Promise.resolve(history.push("".concat(url, "/").concat(item.id)));
        },
        name: Liferay.Language.get('edit')
      }, {
        action: (0, _client.confirmDelete)('/o/data-engine/v2.0/data-list-views/'),
        name: Liferay.Language.get('delete')
      }],
      addButton: function addButton() {
        return _react["default"].createElement(_Button["default"], {
          className: "nav-btn nav-btn-monospaced",
          href: "".concat(url, "/add"),
          symbol: "plus",
          tooltip: Liferay.Language.get('new-table-view')
        });
      },
      columns: COLUMNS,
      emptyState: {
        button: function button() {
          return _react["default"].createElement(_Button["default"], {
            displayType: "secondary",
            href: "".concat(url, "/add")
          }, Liferay.Language.get('new-table-view'));
        },
        description: Liferay.Language.get('create-one-or-more-tables-to-display-the-data-held-in-your-data-object'),
        title: Liferay.Language.get('there-are-no-table-views-yet')
      },
      endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-list-views")
    }, function (item) {
      return _objectSpread({}, item, {
        dateCreated: (0, _time.fromNow)(item.dateCreated),
        dateModified: (0, _time.fromNow)(item.dateModified),
        name: _react["default"].createElement(_reactRouterDom.Link, {
          to: "".concat(url, "/").concat(item.id)
        }, item.name.en_US)
      });
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=ListTableViews.es.js.map
});
//# sourceMappingURL=ListTableViews.es.js.map