Liferay.Loader.define("app-builder-web@1.0.31/js/pages/entry/ListEntries.es", ['module', 'exports', 'require', 'data-engine-taglib', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../components/loading/Loading.es', '../../hooks/useQuery.es', '../../utils/client.es', '../../utils/toast.es', './FieldPreview.es', './PermissionsContext.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dataEngineTaglib = require("data-engine-taglib");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

  var _Loading = require("../../components/loading/Loading.es");

  var _useQuery = require("../../hooks/useQuery.es");

  var _client = require("../../utils/client.es");

  var _toast = require("../../utils/toast.es");

  var _FieldPreview = require("./FieldPreview.es");

  var _PermissionsContext = require("./PermissionsContext.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var ListEntries = (0, _reactRouterDom.withRouter)(function (_ref) {
    var history = _ref.history,
        location = _ref.location;

    var _useState = (0, _react.useState)({
      dataDefinition: null,
      dataListView: {
        fieldNames: []
      },
      isLoading: true
    }),
        _useState2 = _slicedToArray(_useState, 2),
        state = _useState2[0],
        setState = _useState2[1];

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        basePortletURL = _useContext.basePortletURL,
        dataDefinitionId = _useContext.dataDefinitionId,
        dataListViewId = _useContext.dataListViewId,
        showFormView = _useContext.showFormView;

    var actionIds = (0, _react.useContext)(_PermissionsContext.PermissionsContext);
    var hasAddPermission = actionIds.includes(_PermissionsContext.ACTIONS.ADD_DATA_RECORD);
    var hasViewPermission = actionIds.includes(_PermissionsContext.ACTIONS.VIEW_DATA_RECORD);
    (0, _react.useEffect)(function () {
      Promise.all([(0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId)), (0, _client.getItem)("/o/data-engine/v2.0/data-list-views/".concat(dataListViewId))]).then(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            dataDefinition = _ref3[0],
            dataListView = _ref3[1];

        setState(function (prevState) {
          return _objectSpread({}, prevState, {
            dataDefinition: _objectSpread({}, prevState.dataDefinition, {}, dataDefinition),
            dataListView: _objectSpread({}, prevState.dataListView, {}, dataListView),
            isLoading: false
          });
        });
      })["catch"](function () {
        setState(function (prevState) {
          return _objectSpread({}, prevState, {
            isLoading: false
          });
        });
        (0, _toast.errorToast)(Liferay.Language.get('an-unexpected-error-occurred'));
      });
    }, [dataDefinitionId, dataListViewId]);
    var dataDefinition = state.dataDefinition,
        dataListView = state.dataListView,
        isLoading = state.isLoading;
    var columns = dataListView.fieldNames;

    var getEditURL = function getEditURL() {
      var dataRecordId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      return Liferay.Util.PortletURL.createRenderURL(basePortletURL, {
        dataRecordId: dataRecordId,
        mvcPath: '/edit_entry.jsp'
      });
    };

    var handleEditItem = function handleEditItem(dataRecordId) {
      Liferay.Util.navigate(getEditURL(dataRecordId));
    };

    var actions = [];

    if (showFormView) {
      if (hasViewPermission) {
        actions.push({
          action: function action(_ref4) {
            var viewURL = _ref4.viewURL;
            return Promise.resolve(history.push(viewURL));
          },
          name: Liferay.Language.get('view')
        });
      }

      if (actionIds.includes(_PermissionsContext.ACTIONS.UPDATE_DATA_RECORD)) {
        actions.push({
          action: function action(_ref5) {
            var id = _ref5.id;
            return Promise.resolve(handleEditItem(id));
          },
          name: Liferay.Language.get('edit')
        });
      }

      if (actionIds.includes(_PermissionsContext.ACTIONS.DELETE_DATA_RECORD)) {
        actions.push({
          action: function action(item) {
            return (0, _client.confirmDelete)('/o/data-engine/v2.0/data-records/')(item).then(function (confirmed) {
              if (confirmed) {
                (0, _toast.successToast)(Liferay.Language.get('an-entry-was-deleted'));
              }

              return Promise.resolve(confirmed);
            });
          },
          name: Liferay.Language.get('delete')
        });
      }
    }

    return _react["default"].createElement(_Loading.Loading, {
      isLoading: isLoading
    }, _react["default"].createElement(_ListView["default"], {
      actions: actions,
      addButton: function addButton() {
        return showFormView && hasAddPermission && _react["default"].createElement(_Button["default"], {
          className: "nav-btn nav-btn-monospaced",
          onClick: function onClick() {
            return handleEditItem(0);
          },
          symbol: "plus",
          tooltip: Liferay.Language.get('new-entry')
        });
      },
      columns: columns.map(function (column) {
        return {
          key: 'dataRecordValues/' + column,
          sortable: true,
          value: _dataEngineTaglib.DataDefinitionUtils.getFieldLabel(dataDefinition, column)
        };
      }),
      emptyState: {
        button: function button() {
          return showFormView && hasAddPermission && _react["default"].createElement(_Button["default"], {
            displayType: "secondary",
            onClick: function onClick() {
              return handleEditItem(0);
            }
          }, Liferay.Language.get('new-entry'));
        },
        title: Liferay.Language.get('there-are-no-entries-yet')
      },
      endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-records"),
      queryParams: {
        dataListViewId: dataListViewId
      }
    }, function (item, index) {
      var _item$dataRecordValue = item.dataRecordValues,
          dataRecordValues = _item$dataRecordValue === void 0 ? {} : _item$dataRecordValue,
          id = item.id;
      var query = (0, _useQuery.toQuery)(location.search, {
        keywords: '',
        page: 1,
        pageSize: 20,
        sort: ''
      });
      var entryIndex = query.pageSize * (query.page - 1) + index + 1;
      var viewURL = "/entries/".concat(entryIndex, "?").concat((0, _useQuery.toQueryString)(query));
      var displayedDataRecordValues = {};
      columns.forEach(function (fieldName, columnIndex) {
        var fieldValuePreview = _react["default"].createElement(_FieldPreview.FieldValuePreview, {
          dataDefinition: dataDefinition,
          dataRecordValues: dataRecordValues,
          displayType: "list",
          fieldName: fieldName
        });

        if (columnIndex === 0 && hasViewPermission) {
          fieldValuePreview = _react["default"].createElement(_reactRouterDom.Link, {
            to: viewURL
          }, fieldValuePreview);
        }

        displayedDataRecordValues['dataRecordValues/' + fieldName] = fieldValuePreview;
      });
      return _objectSpread({}, displayedDataRecordValues, {
        id: id,
        viewURL: viewURL
      });
    }));
  });
  var _default = ListEntries;
  exports["default"] = _default;
  //# sourceMappingURL=ListEntries.es.js.map
});
//# sourceMappingURL=ListEntries.es.js.map