Liferay.Loader.define("app-builder-web@1.0.31/js/pages/apps/edit/EditApp.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../components/control-menu/ControlMenu.es', '../../../components/loading/Loading.es', '../../../components/multi-step-nav/MultiStepNav.es', '../../../utils/client.es', './DeployApp.es', './EditAppBody.es', './EditAppContext.es', './EditAppFooter.es', './EditAppHeader.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _ControlMenu = _interopRequireDefault(require("../../../components/control-menu/ControlMenu.es"));

  var _Loading = require("../../../components/loading/Loading.es");

  var _MultiStepNav = _interopRequireDefault(require("../../../components/multi-step-nav/MultiStepNav.es"));

  var _client = require("../../../utils/client.es");

  var _DeployApp = _interopRequireDefault(require("./DeployApp.es"));

  var _EditAppBody = _interopRequireDefault(require("./EditAppBody.es"));

  var _EditAppContext = _interopRequireWildcard(require("./EditAppContext.es"));

  var _EditAppFooter = _interopRequireDefault(require("./EditAppFooter.es"));

  var _EditAppHeader = _interopRequireDefault(require("./EditAppHeader.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var _default = function _default(_ref) {
    var _ref$match$params = _ref.match.params,
        appId = _ref$match$params.appId,
        dataDefinitionId = _ref$match$params.dataDefinitionId;

    var _useState = (0, _react.useState)(0),
        _useState2 = _slicedToArray(_useState, 2),
        currentStep = _useState2[0],
        setCurrentStep = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        isLoading = _useState4[0],
        setLoading = _useState4[1];

    var _useReducer = (0, _react.useReducer)(_EditAppContext.reducer, {
      app: {
        active: true,
        appDeployments: [],
        dataLayoutId: null,
        dataListViewId: null,
        name: {
          en_US: ''
        }
      }
    }),
        _useReducer2 = _slicedToArray(_useReducer, 2),
        state = _useReducer2[0],
        dispatch = _useReducer2[1];

    (0, _react.useEffect)(function () {
      if (appId) {
        setLoading(true);
        (0, _client.getItem)("/o/app-builder/v1.0/apps/".concat(appId)).then(function (app) {
          dispatch({
            app: app,
            type: _EditAppContext.UPDATE_APP
          });
          setLoading(false);
        })["catch"](function (_) {
          return setLoading(false);
        });
      }
    }, [appId]);
    var title = Liferay.Language.get('new-app');

    if (appId) {
      title = Liferay.Language.get('edit-app');
    }

    var getEmptyState = function getEmptyState(description, title) {
      return {
        description: description,
        title: title
      };
    };

    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_ControlMenu["default"], {
      backURL: "../",
      title: title
    }), _react["default"].createElement(_Loading.Loading, {
      isLoading: isLoading
    }, _react["default"].createElement(_EditAppContext["default"].Provider, {
      value: {
        dispatch: dispatch,
        state: state
      }
    }, _react["default"].createElement("div", {
      className: "container-fluid container-fluid-max-lg mt-4"
    }, _react["default"].createElement("div", {
      className: "card card-root mb-0 shadowless-card"
    }, _react["default"].createElement(_EditAppHeader["default"], null), _react["default"].createElement("div", {
      className: "card-body p-0 shadowless-card-body"
    }, _react["default"].createElement("div", {
      className: "autofit-row"
    }, _react["default"].createElement("div", {
      className: "col-md-12"
    }, _react["default"].createElement(_MultiStepNav["default"], {
      currentStep: currentStep,
      steps: ['1', '2', '3']
    }))), currentStep == 0 && _react["default"].createElement(_EditAppBody["default"], {
      emptyState: getEmptyState(Liferay.Language.get('create-one-or-more-forms-to-display-the-data-held-in-your-data-object'), Liferay.Language.get('there-are-no-form-views-yet')),
      endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-layouts"),
      itemType: "DATA_LAYOUT",
      title: Liferay.Language.get('select-a-form-view')
    }), currentStep == 1 && _react["default"].createElement(_EditAppBody["default"], {
      emptyState: getEmptyState(Liferay.Language.get('create-one-or-more-tables-to-display-the-data-held-in-your-data-object'), Liferay.Language.get('there-are-no-table-views-yet')),
      endpoint: "/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-list-views"),
      itemType: "DATA_LIST_VIEW",
      title: Liferay.Language.get('select-a-table-view')
    }), currentStep == 2 && _react["default"].createElement(_DeployApp["default"], null)), _react["default"].createElement("h4", {
      className: "card-divider"
    }), _react["default"].createElement(_EditAppFooter["default"], {
      currentStep: currentStep,
      onCurrentStepChange: function onCurrentStepChange(step) {
        setCurrentStep(step);
      }
    }))))));
  };

  exports["default"] = _default;
  //# sourceMappingURL=EditApp.es.js.map
});
//# sourceMappingURL=EditApp.es.js.map