Liferay.Loader.define("app-builder-web@1.0.31/js/pages/apps/ListApps.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/label', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../hooks/useDeployApp.es', '../../utils/client.es', '../../utils/time.es', '../../utils/utils.es', './constants.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

  var _useDeployApp2 = _interopRequireDefault(require("../../hooks/useDeployApp.es"));

  var _client = require("../../utils/client.es");

  var _time = require("../../utils/time.es");

  var _utils = require("../../utils/utils.es");

  var _constants = require("./constants.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _toArray(arr) {
    return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var _default = function _default(_ref) {
    var _ref$match = _ref.match,
        dataDefinitionId = _ref$match.params.dataDefinitionId,
        url = _ref$match.url;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        getStandaloneURL = _useContext.getStandaloneURL,
        userId = _useContext.userId;

    var _useDeployApp = (0, _useDeployApp2["default"])(),
        deployApp = _useDeployApp.deployApp,
        undeployApp = _useDeployApp.undeployApp;

    var ACTIONS = [{
      action: function action(item) {
        return item.active ? undeployApp(item) : deployApp(item);
      },
      name: function name(item) {
        return item.active ? _constants.DEPLOYMENT_ACTION.undeploy : _constants.DEPLOYMENT_ACTION.deploy;
      }
    }, {
      action: function action(item) {
        return Promise.resolve(window.open(getStandaloneURL(item.id), '_blank'));
      },
      name: Liferay.Language.get('open-standalone-app'),
      show: function show(item) {
        return item.appDeployments.some(function (deployment) {
          return deployment.type === 'standalone';
        });
      }
    }, {
      action: (0, _client.confirmDelete)('/o/app-builder/v1.0/apps/'),
      name: Liferay.Language.get('delete')
    }];
    var COLUMNS = [{
      key: 'name',
      sortable: true,
      value: Liferay.Language.get('name')
    }, {
      key: 'type',
      value: Liferay.Language.get('deployed-as')
    }, {
      key: 'dateCreated',
      sortable: true,
      value: Liferay.Language.get('create-date')
    }, {
      asc: false,
      key: 'dateModified',
      sortable: true,
      value: Liferay.Language.get('modified-date')
    }, {
      key: 'status',
      value: Liferay.Language.get('status')
    }];
    var EMPTY_STATE = {
      title: Liferay.Language.get('there-are-no-apps-yet')
    };
    var ENDPOINT = "/o/app-builder/v1.0/apps";
    var FILTERS = [{
      items: [{
        label: _constants.DEPLOYMENT_TYPES.productMenu,
        value: 'productMenu'
      }, {
        label: _constants.DEPLOYMENT_TYPES.standalone,
        value: 'standalone'
      }, {
        label: _constants.DEPLOYMENT_TYPES.widget,
        value: 'widget'
      }],
      key: 'deploymentTypes',
      multiple: true,
      name: 'deployment-type'
    }, {
      items: [{
        label: _constants.STATUSES.active,
        value: 'true'
      }, {
        label: _constants.STATUSES.inactive,
        value: 'false'
      }],
      key: 'active',
      name: 'status'
    }, {
      items: [{
        label: Liferay.Language.get('me'),
        value: userId
      }],
      key: 'userIds',
      multiple: true,
      name: 'author'
    }];

    if (dataDefinitionId) {
      EMPTY_STATE = _objectSpread({}, EMPTY_STATE, {
        button: function button() {
          return _react["default"].createElement(_Button["default"], {
            displayType: "secondary",
            href: "".concat(url, "/deploy")
          }, Liferay.Language.get('new-app'));
        },
        description: Liferay.Language.get('select-the-form-and-table-view-you-want-and-deploy-your-app-as-a-widget-standalone-or-place-it-in-the-product-menu')
      });
      ENDPOINT = "/o/app-builder/v1.0/data-definitions/".concat(dataDefinitionId, "/apps");
    } else {
      var _COLUMNS = COLUMNS,
          _COLUMNS2 = _toArray(_COLUMNS),
          firstColumn = _COLUMNS2[0],
          otherColumns = _COLUMNS2.slice(1);

      COLUMNS = [firstColumn, {
        key: 'dataDefinitionName',
        value: Liferay.Language.get('object')
      }].concat(_toConsumableArray(otherColumns));
    }

    return _react["default"].createElement(_ListView["default"], {
      actions: ACTIONS,
      addButton: dataDefinitionId && function () {
        return _react["default"].createElement(_Button["default"], {
          className: "nav-btn nav-btn-monospaced",
          href: "".concat(url, "/deploy"),
          symbol: "plus",
          tooltip: Liferay.Language.get('new-app')
        });
      },
      columns: COLUMNS,
      emptyState: EMPTY_STATE,
      endpoint: ENDPOINT,
      filters: !dataDefinitionId ? FILTERS : []
    }, function (item) {
      return _objectSpread({}, item, {
        active: item.active,
        dateCreated: (0, _time.fromNow)(item.dateCreated),
        dateModified: (0, _time.fromNow)(item.dateModified),
        name: dataDefinitionId ? _react["default"].createElement(_reactRouterDom.Link, {
          to: "/custom-object/".concat(dataDefinitionId, "/apps/").concat(item.id)
        }, item.name.en_US) : item.name.en_US,
        nameText: item.name.en_US,
        status: _react["default"].createElement(_label["default"], {
          displayType: item.active ? 'success' : 'secondary'
        }, _constants.STATUSES[item.active ? 'active' : 'inactive']),
        type: (0, _utils.concatValues)(item.appDeployments.map(function (_ref2) {
          var type = _ref2.type;
          return _constants.DEPLOYMENT_TYPES[type];
        }))
      });
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=ListApps.es.js.map
});
//# sourceMappingURL=ListApps.es.js.map