Liferay.Loader.define("app-builder-web@1.0.31/js/hooks/useDoubleClick.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _react = require("frontend-js-react-web$react");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  var useCancellablePromises = function useCancellablePromises() {
    var pendingPromises = (0, _react.useRef)([]);

    return {
      append: function append(promise) {
        pendingPromises.current = [].concat(_toConsumableArray(pendingPromises.current), [promise]);
      },
      clear: function clear() {
        pendingPromises.current.map(function (p) {
          return p.cancel();
        });
      },
      remove: function remove(promise) {
        pendingPromises.current = pendingPromises.current.filter(function (p) {
          return p !== promise;
        });
      }
    };
  };

  var cancellablePromise = function cancellablePromise(promise) {
    var isCanceled = false;
    var wrappedPromise = new Promise(function (resolve, reject) {
      promise.then(function (value) {
        return isCanceled ? reject({
          isCanceled: isCanceled,
          value: value
        }) : resolve(value);
      }, function (error) {
        return reject({
          error: error,
          isCanceled: isCanceled
        });
      });
    });
    return {
      cancel: function cancel() {
        isCanceled = true;
      },
      promise: wrappedPromise
    };
  };

  var _default = function _default(onClick, onDoubleClick) {
    var promises = useCancellablePromises();

    return [function handleOnClick(event) {
      promises.clear();
      var waitForClick = cancellablePromise(new Promise(function (resolve) {
        return setTimeout(resolve, 300);
      }));
      promises.append(waitForClick);
      return waitForClick.promise.then(function () {
        promises.remove(waitForClick);
        onClick(event);
      })["catch"](function (e) {
        promises.remove(waitForClick);

        if (!e.isCanceled) {
          throw e.error;
        }
      });
    }, function handleOnDoubleClick(event) {
      promises.clear();
      onDoubleClick(event);
    }];
  };

  exports["default"] = _default;
  //# sourceMappingURL=useDoubleClick.es.js.map
});
//# sourceMappingURL=useDoubleClick.es.js.map