Liferay.Loader.define("app-builder-web@1.0.31/js/components/management-toolbar/SearchContext.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.reducer = void 0;

  var _react = require("frontend-js-react-web$react");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var reducer = function reducer(state, action) {
    switch (action.type) {
      case 'CHANGE_PAGE':
        return _objectSpread({}, state, {
          page: action.page
        });

      case 'CHANGE_PAGE_SIZE':
        return _objectSpread({}, state, {
          page: 1,
          pageSize: action.pageSize
        });

      case 'CLEAR':
        return _objectSpread({}, state, {
          filters: {},
          keywords: ''
        });

      case 'REMOVE_FILTER':
        {
          var filterKey = action.filterKey;

          var updatedFilters = _objectSpread({}, state.filters);

          delete updatedFilters[filterKey];
          return _objectSpread({}, state, {
            filters: updatedFilters
          });
        }

      case 'SEARCH':
        return _objectSpread({}, state, {
          keywords: action.keywords,
          page: 1
        });

      case 'SORT':
        return _objectSpread({}, state, {
          sort: action.sort
        });

      case 'UPDATE_FILTERS_AND_SORT':
        return _objectSpread({}, state, {
          filters: action.filters,
          page: 1,
          sort: action.sort
        });

      default:
        return state;
    }
  };

  exports.reducer = reducer;
  var SearchContext = (0, _react.createContext)();
  var _default = SearchContext;
  exports["default"] = _default;
  //# sourceMappingURL=SearchContext.es.js.map
});
//# sourceMappingURL=SearchContext.es.js.map