/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.rest.internal.resource.v1_0;

import com.liferay.app.builder.rest.dto.v1_0.App;
import com.liferay.app.builder.rest.resource.v1_0.AppResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseAppResourceImpl
implements AppResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<App> {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="active"), @Parameter(in=ParameterIn.QUERY, name="deploymentTypes"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="scope"), @Parameter(in=ParameterIn.QUERY, name="userIds"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/apps")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public Page<App> getAppsPage(@Parameter(hidden=true) @QueryParam(value="active") Boolean active, @Parameter(hidden=true) @QueryParam(value="deploymentTypes") String[] deploymentTypes, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="scope") String scope, @Parameter(hidden=true) @QueryParam(value="userIds") Long[] userIds, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="appId")})
    @Path(value="/apps/{appId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public void deleteApp(@NotNull @Parameter(hidden=true) @PathParam(value="appId") Long appId) throws Exception {
    }

    @Consumes(value={"application/json"})
    @DELETE
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/apps/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="App")})
    public Response deleteAppBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(App.class.getName(), callbackURL, object)).build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="appId")})
    @Path(value="/apps/{appId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public App getApp(@NotNull @Parameter(hidden=true) @PathParam(value="appId") Long appId) throws Exception {
        return new App();
    }

    @Consumes(value={"application/json", "application/xml"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="appId")})
    @Path(value="/apps/{appId}")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public App putApp(@NotNull @Parameter(hidden=true) @PathParam(value="appId") Long appId, App app) throws Exception {
        return new App();
    }

    @Consumes(value={"application/json"})
    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Path(value="/apps/batch")
    @Produces(value={"application/json"})
    @Tags(value={@Tag(name="App")})
    public Response putAppBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(App.class.getName(), callbackURL, object)).build();
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="appId")})
    @Path(value="/apps/{appId}/deploy")
    @Tags(value={@Tag(name="App")})
    public Response putAppDeploy(@NotNull @Parameter(hidden=true) @PathParam(value="appId") Long appId) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @PUT
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="appId")})
    @Path(value="/apps/{appId}/undeploy")
    @Tags(value={@Tag(name="App")})
    public Response putAppUndeploy(@NotNull @Parameter(hidden=true) @PathParam(value="appId") Long appId) throws Exception {
        Response.ResponseBuilder responseBuilder = Response.ok();
        return responseBuilder.build();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="scope"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/data-definitions/{dataDefinitionId}/apps")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public Page<App> getDataDefinitionAppsPage(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="scope") String scope, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Consumes(value={"application/json", "application/xml"})
    @POST
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="dataDefinitionId")})
    @Path(value="/data-definitions/{dataDefinitionId}/apps")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public App postDataDefinitionApp(@NotNull @Parameter(hidden=true) @PathParam(value="dataDefinitionId") Long dataDefinitionId, App app) throws Exception {
        return new App();
    }

    @GET
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="scope"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Path(value="/sites/{siteId}/apps")
    @Produces(value={"application/json", "application/xml"})
    @Tags(value={@Tag(name="App")})
    public Page<App> getSiteAppsPage(@NotNull @Parameter(hidden=true) @PathParam(value="siteId") Long siteId, @Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="scope") String scope, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void create(Collection<App> apps, Map<String, Serializable> parameters) throws Exception {
    }

    public void delete(Collection<App> apps, Map<String, Serializable> parameters) throws Exception {
        for (App app : apps) {
            this.deleteApp(app.getId());
        }
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public Page<App> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getSiteAppsPage((Long)parameters.get("siteId"), (String)((Object)parameters.get("keywords")), (String)((Object)parameters.get("scope")), pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<App> apps, Map<String, Serializable> parameters) throws Exception {
        for (App app : apps) {
            this.putApp(app.getId() != null ? app.getId() : (Long)parameters.get("appId"), app);
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R> R[] transform(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, Exception> unsafeFunction, Class<?> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R> List<R> transformToList(T[] array, UnsafeFunction<T, R, Exception> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }
}

