/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.rest.internal.resource.v1_0;

import com.liferay.app.builder.deploy.AppDeployer;
import com.liferay.app.builder.deploy.AppDeployerTracker;
import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.model.AppBuilderAppVersion;
import com.liferay.app.builder.rest.dto.v1_0.App;
import com.liferay.app.builder.rest.dto.v1_0.AppDeployment;
import com.liferay.app.builder.rest.internal.jaxrs.exception.InvalidAppException;
import com.liferay.app.builder.rest.internal.jaxrs.exception.NoSuchDataListViewException;
import com.liferay.app.builder.rest.internal.odata.entity.v1_0.AppBuilderAppEntityModel;
import com.liferay.app.builder.rest.internal.resource.v1_0.BaseAppResourceImpl;
import com.liferay.app.builder.rest.internal.resource.v1_0.util.LocalizedValueUtil;
import com.liferay.app.builder.rest.resource.v1_0.AppResource;
import com.liferay.app.builder.service.AppBuilderAppDeploymentLocalService;
import com.liferay.app.builder.service.AppBuilderAppLocalService;
import com.liferay.app.builder.service.AppBuilderAppVersionLocalService;
import com.liferay.app.builder.util.comparator.AppBuilderAppCreateDateComparator;
import com.liferay.app.builder.util.comparator.AppBuilderAppModifiedDateComparator;
import com.liferay.app.builder.util.comparator.AppBuilderAppNameComparator;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureLayoutException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/app.properties"}, scope=ServiceScope.PROTOTYPE, service={AppResource.class})
public class AppResourceImpl
extends BaseAppResourceImpl
implements EntityModelResource {
    private static final EntityModel _entityModel = new AppBuilderAppEntityModel();
    @Reference
    private AppBuilderAppDeploymentLocalService _appBuilderAppDeploymentLocalService;
    @Reference
    private AppBuilderAppLocalService _appBuilderAppLocalService;
    @Reference
    private AppBuilderAppVersionLocalService _appBuilderAppVersionLocalService;
    @Reference
    private AppDeployerTracker _appDeployerTracker;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    private ModelResourcePermission<AppBuilderApp> _modelResourcePermission;
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.app.builder)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private ResourceLocalService _resourceLocalService;

    @Override
    public void deleteApp(Long appId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), appId.longValue(), "DELETE");
        this._appBuilderAppLocalService.deleteAppBuilderApp(appId.longValue());
    }

    @Override
    public App getApp(Long appId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), appId.longValue(), "VIEW");
        return this._toApp(this._appBuilderAppLocalService.getAppBuilderApp(appId.longValue()));
    }

    @Override
    public Page<App> getAppsPage(Boolean active, String[] deploymentTypes, String keywords, String scope, Long[] userIds, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Objects.isNull(active) && ArrayUtil.isEmpty((Object[])deploymentTypes) && Validator.isNull((String)keywords) && Validator.isNull((String)scope) && ArrayUtil.isEmpty((Object[])userIds)) {
            return Page.of(this.transform(this._appBuilderAppLocalService.getCompanyAppBuilderApps(this.contextCompany.getCompanyId(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts[0])), this::_toApp), (Pagination)pagination, (long)this._appBuilderAppLocalService.getCompanyAppBuilderAppsCount(this.contextCompany.getCompanyId()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            if (Objects.nonNull(active)) {
                booleanFilter.add((Filter)new TermFilter("active", String.valueOf(active)), BooleanClauseOccur.MUST);
            }
            if (ArrayUtil.isNotEmpty((Object[])deploymentTypes)) {
                BooleanQueryImpl deploymentTypesBooleanQuery = new BooleanQueryImpl();
                for (String deploymentType : deploymentTypes) {
                    deploymentTypesBooleanQuery.addTerm("deploymentTypes", deploymentType);
                }
                booleanFilter.add((Filter)new QueryFilter((Query)deploymentTypesBooleanQuery), BooleanClauseOccur.MUST);
            }
            if (ArrayUtil.isNotEmpty((Object[])userIds)) {
                TermsFilter userIdTermsFilter = new TermsFilter("userId");
                userIdTermsFilter.addValues((String[])Stream.of(userIds).map(String::valueOf).toArray(String[]::new));
                booleanFilter.add((Filter)userIdTermsFilter, BooleanClauseOccur.MUST);
            }
            if (Validator.isNotNull((String)scope)) {
                BooleanQueryImpl scopeBooleanQuery = new BooleanQueryImpl();
                scopeBooleanQuery.addTerm("scope", scope);
                booleanFilter.add((Filter)new QueryFilter((Query)scopeBooleanQuery), BooleanClauseOccur.MUST);
            }
        }, null, AppBuilderApp.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(AppBuilderApp.class)));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toApp(this._appBuilderAppLocalService.fetchAppBuilderApp(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public Page<App> getDataDefinitionAppsPage(Long dataDefinitionId, String keywords, String scope, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        if (Validator.isNotNull((String)keywords)) {
            return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
                if (Validator.isNotNull((String)scope)) {
                    BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                    BooleanQueryImpl scopeBooleanQuery = new BooleanQueryImpl();
                    scopeBooleanQuery.addTerm("scope", scope);
                    booleanFilter.add((Filter)new QueryFilter((Query)scopeBooleanQuery), BooleanClauseOccur.MUST);
                }
            }, null, AppBuilderApp.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
                searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(AppBuilderApp.class)));
                searchContext.setAttribute("name", (Serializable)((Object)keywords));
                searchContext.setAttribute("ddmStructureId", (Serializable)dataDefinitionId);
                searchContext.setCompanyId(this.contextCompany.getCompanyId());
                searchContext.setGroupIds(new long[]{ddmStructure.getGroupId()});
            }, (Sort[])sorts, document -> this._toApp(this._appBuilderAppLocalService.fetchAppBuilderApp(GetterUtil.getLong((String)document.get("entryClassPK")))));
        }
        if (Validator.isNotNull((String)scope)) {
            return Page.of(this.transform(this._appBuilderAppLocalService.getAppBuilderApps(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId(), scope, pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts[0])), this::_toApp), (Pagination)pagination, (long)this._appBuilderAppLocalService.getAppBuilderAppsCount(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId(), scope));
        }
        return Page.of(this.transform(this._appBuilderAppLocalService.getAppBuilderApps(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts[0])), this::_toApp), (Pagination)pagination, (long)this._appBuilderAppLocalService.getAppBuilderAppsCount(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), ddmStructure.getStructureId()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Page<App> getSiteAppsPage(Long siteId, String keywords, String scope, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new BadRequestException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords) && Validator.isNull((String)scope)) {
            return Page.of(this.transform(this._appBuilderAppLocalService.getAppBuilderApps(siteId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator(sorts[0])), this::_toApp), (Pagination)pagination, (long)this._appBuilderAppLocalService.getAppBuilderAppsCount(siteId.longValue()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
            if (Validator.isNotNull((String)scope)) {
                BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
                BooleanQueryImpl scopeBooleanQuery = new BooleanQueryImpl();
                scopeBooleanQuery.addTerm("scope", scope);
                booleanFilter.add((Filter)new QueryFilter((Query)scopeBooleanQuery), BooleanClauseOccur.MUST);
            }
        }, null, AppBuilderApp.class, (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(this._portal.getClassNameId(AppBuilderApp.class)));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> this._toApp(this._appBuilderAppLocalService.fetchAppBuilderApp(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public App postDataDefinitionApp(Long dataDefinitionId, App app) throws Exception {
        if (!this._portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), this.contextCompany.getGroupId(), "MANAGE")) {
            this._portletResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), this.contextCompany.getGroupId(), "ADD_APP");
        }
        this._validate(app.getActive(), app.getDataLayoutId(), app.getDataListViewId(), app.getName());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        AppBuilderApp appBuilderApp = null;
        appBuilderApp = Objects.isNull(app.getDataRecordCollectionId()) ? this._appBuilderAppLocalService.addAppBuilderApp(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), PrincipalThreadLocal.getUserId(), app.getActive().booleanValue(), dataDefinitionId.longValue(), GetterUtil.getLong((Object)app.getDataLayoutId()), GetterUtil.getLong((Object)app.getDataListViewId()), LocalizedValueUtil.toLocaleStringMap(app.getName()), GetterUtil.getString((String)app.getScope(), (String)"standard")) : this._appBuilderAppLocalService.addAppBuilderApp(ddmStructure.getGroupId(), this.contextCompany.getCompanyId(), PrincipalThreadLocal.getUserId(), app.getActive().booleanValue(), app.getDataRecordCollectionId().longValue(), dataDefinitionId.longValue(), GetterUtil.getLong((Object)app.getDataLayoutId()), GetterUtil.getLong((Object)app.getDataListViewId()), LocalizedValueUtil.toLocaleStringMap(app.getName()), GetterUtil.getString((String)app.getScope(), (String)"standard"));
        app.setId(Long.valueOf(appBuilderApp.getAppBuilderAppId()));
        for (AppDeployment appDeployment : app.getAppDeployments()) {
            this._appBuilderAppDeploymentLocalService.addAppBuilderAppDeployment(app.getId().longValue(), this._toJSONString(appDeployment.getSettings()), appDeployment.getType());
            AppDeployer appDeployer = this._appDeployerTracker.getAppDeployer(appDeployment.getType());
            appDeployer.deploy(app.getId().longValue());
        }
        this._resourceLocalService.addResources(this.contextCompany.getCompanyId(), this.contextCompany.getGroupId(), this.contextUser.getUserId(), AppBuilderApp.class.getName(), appBuilderApp.getPrimaryKey(), false, false, false);
        return this._toApp(appBuilderApp);
    }

    @Override
    public App putApp(Long appId, App app) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), appId.longValue(), "UPDATE");
        this._validate(app.getActive(), app.getDataLayoutId(), app.getDataListViewId(), app.getName());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(app.getDataDefinitionId().longValue());
        AppBuilderApp appBuilderApp = this._appBuilderAppLocalService.updateAppBuilderApp(PrincipalThreadLocal.getUserId(), appId.longValue(), app.getActive().booleanValue(), ddmStructure.getStructureId(), GetterUtil.getLong((Object)app.getDataLayoutId()), GetterUtil.getLong((Object)app.getDataListViewId()), LocalizedValueUtil.toLocaleStringMap(app.getName()));
        List appBuilderAppDeployments = this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appId.longValue());
        for (AppBuilderAppDeployment appBuilderAppDeployment : appBuilderAppDeployments) {
            this._appBuilderAppDeploymentLocalService.deleteAppBuilderAppDeployment(appBuilderAppDeployment.getAppBuilderAppDeploymentId());
        }
        for (AppDeployment appDeployment : app.getAppDeployments()) {
            this._appBuilderAppDeploymentLocalService.addAppBuilderAppDeployment(appId.longValue(), this._toJSONString(appDeployment.getSettings()), appDeployment.getType());
            AppDeployer appDeployer = this._appDeployerTracker.getAppDeployer(appDeployment.getType());
            if (appDeployer == null || !app.getActive().booleanValue()) continue;
            appDeployer.deploy(appId.longValue());
        }
        return this._toApp(appBuilderApp);
    }

    @Override
    public Response putAppDeploy(Long appId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), appId.longValue(), "UPDATE");
        for (AppBuilderAppDeployment appBuilderAppDeployment : this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appId.longValue())) {
            AppDeployer appDeployer = this._appDeployerTracker.getAppDeployer(appBuilderAppDeployment.getType());
            if (appDeployer == null) continue;
            appDeployer.deploy(appId.longValue());
        }
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.build();
    }

    @Override
    public Response putAppUndeploy(Long appId) throws Exception {
        this._modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), appId.longValue(), "UPDATE");
        for (AppBuilderAppDeployment appBuilderAppDeployment : this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appId.longValue())) {
            AppDeployer appDeployer = this._appDeployerTracker.getAppDeployer(appBuilderAppDeployment.getType());
            if (appDeployer == null) continue;
            appDeployer.undeploy(appId.longValue());
        }
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.build();
    }

    @Reference(target="(model.class.name=com.liferay.app.builder.model.AppBuilderApp)", unbind="-")
    private void _setModelResourcePermission(ModelResourcePermission<AppBuilderApp> modelResourcePermission) {
        this._modelResourcePermission = modelResourcePermission;
    }

    private App _toApp(final AppBuilderApp appBuilderApp) {
        if (appBuilderApp == null) {
            return null;
        }
        return new App(){
            {
                this.active = appBuilderApp.isActive();
                this.appDeployments = (AppDeployment[])AppResourceImpl.this.transformToArray(AppResourceImpl.this._appBuilderAppDeploymentLocalService.getAppBuilderAppDeployments(appBuilderApp.getAppBuilderAppId()), appBuilderAppDeployment -> new AppDeployment((AppBuilderAppDeployment)appBuilderAppDeployment){
                    final /* synthetic */ AppBuilderAppDeployment val$appBuilderAppDeployment;
                    {
                        this.val$appBuilderAppDeployment = appBuilderAppDeployment;
                        this.settings = AppResourceImpl.this._toSettings(this.val$appBuilderAppDeployment.getSettings());
                        this.type = this.val$appBuilderAppDeployment.getType();
                    }
                }, AppDeployment.class);
                this.dataDefinitionId = appBuilderApp.getDdmStructureId();
                this.dataLayoutId = appBuilderApp.getDdmStructureLayoutId();
                this.dataListViewId = appBuilderApp.getDeDataListViewId();
                this.dataRecordCollectionId = appBuilderApp.getDdlRecordSetId();
                this.dateCreated = appBuilderApp.getCreateDate();
                this.dateModified = appBuilderApp.getModifiedDate();
                this.id = appBuilderApp.getAppBuilderAppId();
                this.name = LocalizedValueUtil.toStringObjectMap(appBuilderApp.getNameMap());
                this.siteId = appBuilderApp.getGroupId();
                this.userId = appBuilderApp.getUserId();
                this.setDataDefinitionName(() -> {
                    DDMStructure ddmStructure = AppResourceImpl.this._ddmStructureLocalService.getDDMStructure(appBuilderApp.getDdmStructureId());
                    return ddmStructure.getName(AppResourceImpl.this.contextAcceptLanguage.getPreferredLocale());
                });
                this.setVersion(() -> {
                    AppBuilderAppVersion latestAppBuilderAppVersion = AppResourceImpl.this._appBuilderAppVersionLocalService.getLatestAppBuilderAppVersion(appBuilderApp.getAppBuilderAppId());
                    return latestAppBuilderAppVersion.getVersion();
                });
            }
        };
    }

    private String _toJSONString(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "";
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return jsonObject.toJSONString();
    }

    private OrderByComparator<AppBuilderApp> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new AppBuilderAppCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new AppBuilderAppNameComparator(ascending);
        }
        return new AppBuilderAppModifiedDateComparator(ascending);
    }

    private Map<String, Object> _toSettings(final String settings) throws Exception {
        return new HashMap<String, Object>(){
            {
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)settings);
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    this.put(key, jsonObject.get(key));
                }
            }
        };
    }

    private void _validate(Boolean active, Long dataLayoutId, Long dataListViewId, Map<String, Object> name) throws Exception {
        DEDataListView deDataListView;
        DDMStructureLayout ddmStructureLayout;
        if (Objects.isNull(active)) {
            throw new InvalidAppException("Active is null");
        }
        if (dataLayoutId == null && dataListViewId == null) {
            throw new InvalidAppException("An app must have one data engine data layout or one data engine data list view");
        }
        if (dataLayoutId != null && (ddmStructureLayout = this._ddmStructureLayoutLocalService.fetchStructureLayout(dataLayoutId.longValue())) == null) {
            throw new NoSuchStructureLayoutException("Data layout " + dataLayoutId + " does not exist");
        }
        if (dataListViewId != null && (deDataListView = this._deDataListViewLocalService.fetchDEDataListView(dataListViewId.longValue())) == null) {
            throw new NoSuchDataListViewException("Data list view " + dataListViewId + " does not exist");
        }
        if (MapUtil.isNotEmpty(name)) {
            for (Object value : name.values()) {
                String localizedName = (String)value;
                if (Validator.isNull((String)localizedName)) {
                    throw new InvalidAppException("The app name is null");
                }
                if (localizedName.length() <= 30) continue;
                throw new InvalidAppException("The app name has more than 30 characters");
            }
        }
    }
}

